/* global jQuery, _ */
/* global window */
/* global document */

// bind click
jQuery(document).on( 'click', '.tds-update-preview', function (event) {
    event.preventDefault();
    window.tdLockerEditor.refresh_preview();
});

if ( !window.tdLockerEditor ) window.tdLockerEditor = {};

( function ($) {

    window.tdLockerEditor = {

        init: function() {
            this.track_input_changes();
            this.initialize_color_pickers();
        },

        // initialize color pickers
        initialize_color_pickers: function () {
            var self = this;

            if ( $().wpColorPicker ) {
                $('input.tds-color-picker').wpColorPicker({
                    change: _.debounce( function(event, ui) {
                        self.refresh_preview();
                    }, 500 ),
                    clear: function(event) {
                        self.refresh_preview();
                    }
                });
            }

        },

        // gets locker options
        get_locker_options: function () {
            var options = {};
            var metaboxes = [ "#tds_locker_settings_metabox", "#tds_locker_styles_metabox" ];

            for ( var index in metaboxes ) {
                $( metaboxes[index] ).find("input, select, textarea").each( function () {
                    var $this = $(this);

                    // we work only with text type inputs
                    if ( $this.is('input') && $this.attr('type') !== 'text' ) {
                        return;
                    }

                    var option = $this.attr('name').match(/\[(.*?)\]/);
                    if ( option ) {
                        var op_name = option[1];

                        // add to options..
                        if ( op_name === 'tds_pp_msg' ) {
                            options[op_name] = window.btoa( encodeURIComponent( $this.val() ) );
                        } else {
                            options[op_name] = $this.val();
                        }
                    }
                });
            }

            return options;
        },

        // track user input to refresh the preview
        track_input_changes: function () {
            var self = this;
            var metaboxes = [ "#tds_locker_settings_metabox", "#tds_locker_styles_metabox" ];

            for ( var index in metaboxes ) {
                $( metaboxes[index] ).find("input, select, textarea").bind( 'change keyup paste', function(e) {
                    console.log(e)
                });
                $( metaboxes[index] ).find("input, select, textarea").bind( 'change keyup paste', _.debounce( function() { self.refresh_preview(); }, 500 ) );
            }
        },

        // refresh locker preview after a short delay
        refresh_preview: function () {
            //console.log('%c Preview Refresh !', 'color: orangered;' );

            // enable loading state
            var preveiwHTML = $('.preview-html'),
                previewLoader = $('.preview-loader');

            preveiwHTML.addClass('preview-html-loading');
            previewLoader.addClass('preview-loader-visible');

            // process shortcode atts from options
            var options = this.get_locker_options();
            var shortcode_atts = '';

            for ( const [att, value] of Object.entries(options) ) {
                shortcode_atts += att + '=' + '"' + value + '" ';
            }

            // shortcode ex: '[tds_locker tds_title="xxx" tds_message="yyy" ... ]';
            var shortcode = '[tds_locker ' + shortcode_atts + ']';

            //console.log( shortcode );

            $.ajax({
                timeout: 10000,
                type: 'POST',
                url: this.get_rest_endpoint(
                    'tds_preview/do_job',
                    'uuid=' + this.get_unique_id()
                ),
                beforeSend: function ( xhr ) {
                    // add the nonce used for cookie authentication
                    xhr.setRequestHeader( 'X-WP-Nonce', window.tds_js_globals.wpRestNonce );
                },
                cache: true,
                data: {
                    shortcode: shortcode,
                    replyHtml: ''
                },
                dataType: 'json',
                statusCode: {
                    404 : function() {
                        console.log('tds preview - ERROR: 404 not found');
                    },
                    500 : function() {
                        console.log('tds preview - ERROR: 500 server error');
                    }
                },
                success: function( data ) {

                    // check for empty response.. empty response evaluates to null in json
                    if ( data === null ) {
                        console.log('%c tds preview - ERROR: Empty response received from server', 'color: orangered;');
                        return;
                    } else {
                        console.log('%c tds preview data response received from server', 'color: green;');
                        console.log(data);
                    }

                    // important! ..the sever response should have this property
                    if ( _.has( data, 'replyHtml' ) ) {
                        preveiwHTML.html( data.replyHtml ); // update preview html

                        // remove loading state
                        setTimeout(function () {
                            previewLoader.removeClass('preview-loader-visible');

                            setTimeout(function () {
                                preveiwHTML.removeClass('preview-html-loading');
                            }, 400);
                        }, 300);
                    }

                },
                // this callback is called when any error is encountered. ( including status codes like 404, 500 etc. )
                error: function( MLHttpRequest, textStatus, errorThrown ) {
                    console.log( 'tds preview - Error callback - textStatus: ' + textStatus + ' errorThrown: ' + errorThrown);
                }
            });

        },

        // handles preview render
        //request_preview: function () {},

        // returns a full rest endpoint url..
        get_rest_endpoint: function ( restEndPoint, queryString ) {

            if ( _.isEmpty( window.tds_js_globals.permalinkStructure ) ) {
                return window.tds_js_globals.wpRestUrl + restEndPoint + '&' + queryString; // no permalinks
            } else {
                return window.tds_js_globals.wpRestUrl + restEndPoint + '?' + queryString; // we have permalinks enabled
            }

        },

        // generates a unique ID
        get_unique_id: function () {
            function s4() {
                return Math.floor((1 + Math.random()) * 0x10000)
                    .toString(16)
                    .substring(1);
            }
            return s4() + s4() + '-' + s4() + '-' + s4() + '-' + s4() + '-' + s4() + s4() + s4();
        }

    };

    $(function(){
        window.tdLockerEditor.init();
    });

})(jQuery);




