/**
 * tds_leads shortcode script
 */

/* global jQuery:{} */

var tdsLeads = {};
( function() {

    'use strict';

    tdsLeads = {

        items: [],

        // initialize items
        init: function () {
            tdsLeads.items = [];
        },

        // item
        item: function item() {

            // the block unique id
            this.blockUid = undefined;

            // the block attributes
            //this.blockAtts = undefined;

            // the block unique id
            this.jqueryObj = undefined;

            // item in composer
            this.inComposer = false;

            // flag to detect from submission
            this.isSubmit = false;

            // flag to detect from submission errors
            this.submitHasErrors = false;

            // redirect url
            //this.rdrUrl = false;

            // flag used to mark the initialization item
            this._is_initialized = false;

        },

        // initialize an item
        _initialize_item: function( item ) {

            // an item must be initialized only once
            if ( true === item._is_initialized ) {
                return;
            }

            // handle redirect after a successful form submit
            // if ( true === item.isSubmit && false === item.submitHasErrors && false !== item.rdrUrl ) {
            //     window.location.replace(item.rdrUrl);
            // }

            // privacy policy acknowledgement check
            item.jqueryObj.find('.tds-submit-btn').on( 'click', function (event) {
                var checkbox = item.jqueryObj.find('.tds-checkbox');
                if ( checkbox.length ) {
                    var pp_checkbox = item.jqueryObj.find('#pp_checkbox_' + item.blockUid);

                    if ( pp_checkbox.length && !pp_checkbox.is(':checked') ) {
                        event.preventDefault();
                        var errMsgsWrap = item.jqueryObj.find('.tds-messages-error');

                        if ( !errMsgsWrap.length ) {
                            item.jqueryObj.find('.tds-info').prepend(
                                '<div class="tds-messages tds-messages-error">' +
                                    '<div class="tds-message tds-message-checkbox">Acknowledgment is required!</div>' +
                                '</div>');
                        } else {
                            var checkboxErrMsg = errMsgsWrap.find('.tds-message-checkbox');

                            if( !checkboxErrMsg.length ) {
                                errMsgsWrap.append('<div class="tds-message tds-message-checkbox">Acknowledgment is required!</div>');
                            }
                        }

                        setTimeout(function () {
                            var errMsgs = jQuery('.' + item.blockUid + ' .tds-messages');

                            if( errMsgs.length ) {
                                errMsgs.addClass('tds-messages-hiding');

                                setTimeout(function () {
                                    errMsgs.remove();
                                }, 300);
                            }
                        }, 3000);
                    }
                }
            });

            // on checkbox change hide errors if it's checked
            item.jqueryObj.find('#pp_checkbox_' + item.blockUid).change( function() {
                var $this = jQuery(this);
                var errMsgs = item.jqueryObj.find('.tds-messages-error'),
                    checkboxError = errMsgs.find('.tds-message-checkbox');

                if ( $this.is(':checked') ) {
                    checkboxError.remove();
                    if ( errMsgs.is(':empty') ) {
                        errMsgs.remove();
                    }
                }
            });

            // the item is marked as initialized
            item._is_initialized = true;

        },

        // add an item
        addItem: function( item ) {

            // check to see if the item is ok
            if (typeof item.blockUid === 'undefined') {
                throw 'item.blockUid is not defined';
            }

            // the item is added in the items list
            tdsLeads.items.push( item );

            // the item is initialized only once when it is added
            tdsLeads._initialize_item( item );
        },

        // deletes an item base on its blockUid
        deleteItem: function( blockUid ) {
            for ( var cnt = 0; cnt < tdsLeads.items.length; cnt++ ) {
                if ( tdsLeads.items[cnt].blockUid === blockUid ) {
                    tdsLeads.items.splice(cnt, 1);
                    return true;
                }
            }
            return false;
        }

    };

})();

jQuery().ready( function() {
    'use strict';

    // initialize tds leads items
    tdsLeads.init();

});