
<!-- locker state checkbox -->
<div class="td-meta-box-row">
	<?php $mb->the_field('tds_lock_content'); ?>
    <span class="td-page-o-custom-label">Lock Content: <?php td_util::tooltip_html('<h3>Full content lock:</h3><p>The post content will be locked for non-subscribed users. The content unlocks only if users subscribe to your emailing list.</p>', 'right'); ?></span>
    <input id="tds-lock-content"
           class=""
           style="position: relative; top: 7px; margin: 0; left: 3px;"
           type="checkbox"
           name="<?php $mb->the_name(); ?>"
           value="1"
           <?php if ( $mb->get_the_value() ) echo ' checked="checked"'; ?>
    />
</div>

<!-- locker select -->
<div class="td-meta-box-row">
	<span class="td-page-o-custom-label">Locker:</span>
	<?php

	// locker id
	$mb->the_field('tds_locker');

	// the default list id
	$default_locker_id = (int) get_option( 'tds_default_locker_id' );

	// default list select state
	$def_locker_select_state = ( $mb->have_value() ) ? '' : ' selected="selected"';

	?>
	<div class="td-select-style-overwrite td-inline-block-wrap">
		<select name="<?php $mb->the_name(); ?>" class="td-panel-dropdown">
            <option value="<?php echo $default_locker_id; ?>"<?php echo $def_locker_select_state; ?>>Default Locker</option>
			<?php

			// get tds lockers
			$tds_lockers = get_posts(
				array(
					'post_type' => 'tds_locker',
                    'post_status' => 'publish',
                    'numberposts' => -1, // get all, no limit
                    'post__not_in' => array( $default_locker_id ), // exclude default locker
				)
			);

			if ( !empty( $tds_lockers ) && is_array( $tds_lockers ) ) {
				foreach ( $tds_lockers as $locker ) {
					?>
                    <option value="<?php echo $locker->ID; ?>"<?php $mb->the_select_state( $locker->ID ); ?>>
						<?php echo $locker->post_title; ?>
                    </option>
					<?php
				}
			}
			?>
		</select>
	</div>
</div>
