<?php


class tds_admin {

	// constructor
	public function __construct() {

		add_action( 'init', array( $this, 'includes' ) );

		// tds email ctp wp admin editor updates > title field placeholder text
		add_filter( 'enter_title_here', function ( $title, $post ) {

			if( $post->post_type === 'tds_email' ) {
				$title = 'Add email';
			}

			return $title;

		}, 10, 2 );

		// add tds_current_locker data to admin head
		//add_filter( 'admin_head', function() {
		//    global $post;
		//    $tds_current_locker = array (
		//        'id' => $post->ID ?? ''
		//    );
		//    echo '<script>window.tds_current_locker = ' . json_encode( $tds_current_locker ) . ' </script>';
		//});

		// remove the default 'new item' from the admin menu
		add_filter( 'custom_menu_order', '__return_true' );
		add_filter( 'menu_order', function ( $menu ) {
			global $submenu;
			if ( !isset( $submenu['edit.php?post_type=tds_email'] ) )
				return $menu;
			unset( $submenu['edit.php?post_type=tds_email'][10] );
			return $menu;
		});

	}

	// includes
	public function includes() {

		// register admin script
		wp_register_script(
		        'tds-preview',
                TDS_URL . '/assets/js/admin/lockers.js',
                array( 'jquery', 'underscore' ),
                TD_SUBSCRIPTION,
                true
        );
		wp_enqueue_script('tds-preview');

        wp_localize_script('tds-preview','tds_js_globals',
            array(
	            'wpRestNonce' => wp_create_nonce('wp_rest'),
	            'wpRestUrl' => rest_url(),
	            'permalinkStructure' => get_option('permalink_structure'),
            )
        );

		// metaboxes
		if ( class_exists( 'WPAlchemy_MetaBox' ) ) {

			new WPAlchemy_MetaBox(
				array(
					'id'       => 'tds_locker_preview',
					'title'    => 'Preview',
					'types'    => array( 'tds_locker' ),
					'priority' => 'default',
					'template' => TDS_PATH . '/includes/admin/metaboxes/tds_locker_preview.php'
				)
			);

			new WPAlchemy_MetaBox(
				array(
					'id'       => 'tds_locker_settings',
					'title'    => 'Basic Locker Settings',
					'types'    => array( 'tds_locker' ),
					'priority' => 'high',
					'template' => TDS_PATH . '/includes/admin/metaboxes/tds_locker_settings.php'
				)
			);

			new WPAlchemy_MetaBox(
				array(
					'id'       => 'tds_locker_styles',
					'title'    => 'Locker Styles',
					'types'    => array( 'tds_locker' ),
					'priority' => 'high',
					'template' => TDS_PATH . '/includes/admin/metaboxes/tds_locker_styles.php'
				)
			);

			new WPAlchemy_MetaBox(
				array(
					'id'       => 'tds_locker_access_settings',
					'title'    => 'Locker Access Settings',
					'types'    => array( 'tds_locker' ),
					'priority' => 'default',
					'template' => TDS_PATH . '/includes/admin/metaboxes/tds_locker_access_settings.php'
				)
			);



		}

	}


}

new tds_admin();