<?php
/**
 * Class tds_email_locker
 */

class tds_email_locker {

	protected static $_instance = null;

	private $is_locked_content = null;
	private $locker_id = null;
	private $locker_leads_list_id = null;

	public static function instance() {
		if ( is_null( self::$_instance ) ) {
			self::$_instance = new self();
		}
		return self::$_instance;
	}

	public function __construct() {

		// hook later.. after wp env setup to access the $post global
		add_action( 'wp', array( $this, 'locker_init' ) );


	}

	public function locker_init() {
		global $post;

		if ( !$post ) {
			return; // return here if global $post si not set
		}

		// read post settings
		$td_post_settings = td_util::get_post_meta_array( $post->ID, 'td_post_theme_settings' );

		// read content lock/locker id settings from post meta settings
		$tds_lock_content = !empty( $td_post_settings['tds_lock_content'] );
		$tds_locker_id = !empty( $td_post_settings['tds_locker'] ) ? (int) $td_post_settings['tds_locker'] : false;

		// read locker list from post meta
		$tds_locker_access_settings = get_post_meta( $tds_locker_id, 'tds_locker_access_settings', true );
		$tds_locker_email_list = !empty( $tds_locker_access_settings['tds_locker_email_list'] ) ? (int) $tds_locker_access_settings['tds_locker_email_list'] : false;

		// return here if no content lock, locker id or locker email list are set
		if ( !$tds_lock_content || !$tds_locker_id || !$tds_locker_email_list )
			return;

		//echo '<pre class="td-container" style="white-space: pre-wrap; word-break: break-all; font-weight: bold">' . PHP_EOL;
		//echo '$tds_leads_cookie_lists: '; ( isset( $_COOKIE['tds_leads'] ) ) ? print_r( $_COOKIE['tds_leads'] ) : print_r('not set !'); echo PHP_EOL;
		//echo '$tds_locker_id: '; print_r( $tds_locker_id ); echo PHP_EOL;
		//echo '$tds_locker_email_list: '; print_r( $tds_locker_email_list ); echo PHP_EOL;

		// process content access from cookie
		$tds_leads_cookie_lock_access = true;
		$tds_leads_cookie = !empty( $_COOKIE['tds_leads'] ) ? $_COOKIE['tds_leads'] : false;
		if ( $tds_leads_cookie ) {

			// get cookie lists
			$tds_leads_cookie_lists = explode( ',', $tds_leads_cookie );

			// check if locker access list is found in the leads cookie..
			// ..if it's found it means that the visitor has access to the list and content should not be blocked..
			if ( in_array( $tds_locker_email_list, $tds_leads_cookie_lists ) ) {
				$tds_leads_cookie_lock_access = false;
			}

		}

		// if content lock is set
		if ( $tds_leads_cookie_lock_access ) {

			// set content as locked
			tds_email_locker::instance()->set_content_locked();

			// set locker id
			tds_email_locker::instance()->set_locker_id($tds_locker_id);

			// set locker leads list id
			tds_email_locker::instance()->set_locker_leads_list_id($tds_locker_email_list);

			// add filter to replace content with locker..
			add_filter( 'the_content', array( $this, 'lock_content' ) );

		}

		//echo '</pre>';

	}

	public function set_locker_id($id) {
		$this->locker_id = $id;
	}

	public function set_locker_leads_list_id($id) {
		$this->locker_leads_list_id = $id;
	}

	public function set_content_locked() {
		$this->is_locked_content = true;
	}

	public function get_locker_id() {
		return $this->locker_id;
	}

	public function get_locker_leads_list_id() {
		return $this->locker_leads_list_id;
	}

	public function is_content_locked() {
		return $this->is_locked_content;
	}

	public function lock_content($content) {
		global $post;

		// do nothing when running for cloud templates
		// @todo maybe it's better to check here if it's 'post' post type..
		if( $post->post_type === 'tdb_templates' ) {
			return $content;
		}

		// $content = '<h1 class="td-container" style="color: orangered; width: 100%; text-align: center;">content locked !!</h1><br>';
        $content = '';

		$tds_locker_id = tds_email_locker::instance()->get_locker_id();
		$tds_locker_settings_meta = get_post_meta( $tds_locker_id, 'tds_locker_settings', true );
		$tds_locker_styles_meta = get_post_meta( $tds_locker_id, 'tds_locker_styles', true );

		// get post permalink to redirect after submitting email to access content..
		$post_permalink = get_permalink( $post->ID );

		// basic locker settings defaults
		$tds_locker_settings_defaults = array (
			'tds_title' => 'This Content Is Only For Subscribers',
			'tds_message' => 'Please subscribe to unlock this content. Enter your email to get access.',
            'tds_input' => '',
			'tds_input_placeholder' => 'Please enter your email address.',
			'tds_submit_btn_text' => 'Subscribe to unlock',
			'tds_after_btn_text' => 'Your email address is 100% safe from spam!',
			'tds_pp_msg' => 'I consent to processing of my data according to <a href="#">Terms of Use</a> & <a href="#">Privacy Policy</a>',
		);

		// build locker styles defaults
		$tds_locker_styles_defaults = array(
            'tds_bg_color' => '',
            'all_tds_border' => '',
            'all_tds_border_color' => '',
            'all_tds_shadow' => '',
            'all_tds_shadow_color' => '',
            'tds_input_color_f' => '',
            'tds_input_bg_color' => '',
            'tds_input_bg_color_f' => '',
            'tds_input_border_color' => '',
            'tds_input_border_color_f' => '',
            'tds_submit_btn_text_color_h' => '',
            'tds_submit_btn_bg_color' => '',
            'tds_submit_btn_bg_color_h' => '',
            'tds_pp_checked_color' => '',
            'tds_pp_check_bg' => '',
            'tds_pp_check_bg_f' => '',
            'tds_pp_check_border_color' => '',
            'tds_pp_check_border_color_f' => '',
            'tds_pp_msg_links_color' => '',
            'tds_pp_msg_links_color_h' => '',
            'tds_general_font_family' => '',
            'tds_general_font_size' => '',
            'tds_general_font_line_height' => '',
            'tds_general_font_style' => '',
            'tds_general_font_weight' => '',
            'tds_general_font_transform' => '',
            'tds_general_font_spacing' => ''
		);
		foreach ( $tds_locker_settings_defaults as $setting_id => $val ) {
			// colors
			$tds_locker_styles_defaults[$setting_id . '_color'] = '';
			// fonts
			$tds_locker_styles_defaults[$setting_id . '_font_family'] = '';
			$tds_locker_styles_defaults[$setting_id . '_font_size'] = '';
			$tds_locker_styles_defaults[$setting_id . '_font_line_height'] = '';
			$tds_locker_styles_defaults[$setting_id . '_font_style'] = '';
			$tds_locker_styles_defaults[$setting_id . '_font_weight'] = '';
			$tds_locker_styles_defaults[$setting_id . '_font_transform'] = '';
			$tds_locker_styles_defaults[$setting_id . '_font_spacing'] = '';
		}

		$tds_locker_settings = empty( $tds_locker_settings_meta ) ? array() : $tds_locker_settings_meta;
		$tds_locker_styles = empty( $tds_locker_styles_meta ) ? array() : $tds_locker_styles_meta;

		//echo '<pre class="td-container">';
		//print_r($tds_locker_styles);
		//echo '</pre>';

		// locker shortcode atts
		$locker_shortcode_atts = array_merge(
			array_merge( $tds_locker_settings_defaults, $tds_locker_settings ),
			array_merge( $tds_locker_styles_defaults, $tds_locker_styles ),
			array(
				'tds_leads_list' => tds_email_locker::instance()->get_locker_leads_list_id(),
				'tds_successful_submit_rdr_url' => $post_permalink,
				'b64_decode' => false,
			)
		);

		//echo '<pre>';
		//print_r($locker_shortcode_atts);
		//echo '</pre>';
		//die;

		$content .= td_global_blocks::get_instance('tds_locker')->render( $locker_shortcode_atts );

		return $content;
	}


}

tds_email_locker::instance();