<?php

/**
 * Class tds_leads
 */

class tds_leads extends td_block {

	public function get_custom_css() {
        // $unique_block_class - the unique class that is on the block. use this to target the specific instance via css
        $unique_block_class = ((td_util::tdc_is_live_editor_iframe() || td_util::tdc_is_live_editor_ajax()) ? 'tdc-row .' : '') . $this->block_uid;

		$compiled_css = '';

		$raw_css =
            "<style>

                /* @style_general_tds_leads */
                .tds_leads .tds-title {
                    margin-top: 0;
                    margin-bottom: 20px;
                    font-size: 22px;
                    line-height: 1.4; 
                    font-weight: 600; 
                }
                .tds_leads .tds-info:not(:empty) {
                    margin-bottom: 16px; 
                }
                .tds_leads .tds-messages {
                    padding: 8px 12px;
                    font-size: 12px;
                    line-height: 1.4;
                    color: #fff;
                    border-radius: 3px;
                    transition: opacity .2s ease-in-out;
                }
                .tds_leads .tds-messages:not(:last-child) {
                    margin-bottom: .4em;
                }
                .tds_leads .tds-messages-hiding {
                    opacity: 0;
                }
                .tds_leads .tds-messages-error {
                    background-color: #ec4d4d;
                }
                .tds_leads .tds-messages-success {
                    background-color: #6bc16f;
                }
                .tds_leads .tds-message:not(:last-child) {
                    margin-bottom: .4em;
                }
                .tds_leads .tds-email-bar {
                    display: flex;
                }
                .tds_leads .tds-input-wrap {
                    flex: 1;
                }
                .tds_leads .tds-input {
                    height: 100%;
                    padding: 12px 15px;
                    line-height: 1;
                    border-width: 1px 0 1px 1px;
                }
                .tds_leads .tds-submit-btn {
                    -webkit-appearance: none;
                    display: flex;
                    align-items: center;
                    padding: 15px;
                    background-color: #4db2ec;
                    font-size: 13px;
                    line-height: 1;
                    color: #fff;
                    border-width: 0;
                    border-style: solid;
                    border-color: #000;
                    -webkit-transition: all 0.3s ease;
                    transition: all 0.3s ease;
                    outline: none;
                }
                .tds_leads .tds-submit-btn:hover {
                    background-color: #222;
                }
                .tds_leads .tds-submit-btn-icon {
                    position: relative;
                }
                .tds_leads i.tds-submit-btn-icon {
                    font-size: 15px;
                    color: #fff;
                }
                .tds_leads .tds-submit-btn-icon-svg {
                    width: 15px;
                    height: auto;
                }
                .tds_leads .tds-submit-btn-icon-svg svg {
                    display: block;
                    fill: #fff;
                    -webkit-transition: all 0.3s ease;
                    transition: all 0.3s ease;
                }
                .tds_leads .tds-checkbox {
                    margin-top: 16px;
                    line-height: 1;
                }
                .tds_leads .tds-checkbox input {
                    display: none;
                }
                .tds_leads .tds-checkbox label {
                    display: flex;
                    align-items: center;
                    margin-bottom: 0;
                    cursor: pointer;
                }
                .tds_leads .tds-check {
                    position: relative;
                    width: 1em;
                    height: 1em;
                    margin-right: 8px;
                    background-color: #fff;
                    cursor: pointer;
                    border: 1px solid #ccc;
                    transition: all .3s ease-in-out;
                    flex-shrink: 0;
                }
                .tds_leads .tds-check:after {
                    content: '';
                    position: absolute;
                    top: 50%;
                    left: 50%;
                    transform: translate(-50%, -50%);
                    width: 0.5em;
                    height: 0.5em;
                    background-color: #4db2ec;
                    opacity: 0;
                    transition: all .3s ease;
                    pointer-events: none;
                }
                .tds_leads .tds-checkbox input:checked + label .tds-check:after {
                    opacity: 1;
                }
                .tds_leads .tds-check-title {
                    margin-top: -1px;
                    user-select: none;
                    -webkit-user-select: none;
                    font-size: 11px;
                    color: #444;
                }
                .tds_leads .tds-check-title a:hover {
                    color: #222;
                }
                
                
                
                /* @title_space */
                body .$unique_block_class .tds-title {
                    margin-bottom: @title_space;
                }
                
                
                
                /* @msg_space */
                body .$unique_block_class .tds-info:not(:empty) {
                    margin: @msg_space;
                }
                /* @msg_padd */
                body .$unique_block_class .tds-messages {
                    padding: @msg_padd;
                }
                
                /* @all_msg_succ_border */
                body .$unique_block_class .tds-messages-success {
                    border: @all_msg_succ_border @all_msg_succ_border_style @all_msg_succ_border_color;
                }
                /* @msg_succ_radius */
                body .$unique_block_class .tds-messages-success {
                    border-radius: @msg_succ_radius;
                }
                
                /* @all_msg_err_border */
                body .$unique_block_class .tds-messages-error {
                    border: @all_msg_err_border @all_msg_err_border_style @all_msg_err_border_color;
                }
                /* @msg_err_radius */
                body .$unique_block_class .tds-messages-error {
                    border-radius: @msg_err_radius;
                }
                
                
                
                /* @display */
                body .$unique_block_class .tds-email-bar {
                    flex-direction: @display;
                }
                /* @gap1 */
                body .$unique_block_class .tds-input-wrap  {
                    margin: 0 @gap1 0 0;
                }
                body .$unique_block_class .tds-submit-btn {
                    margin: 0 0 0 @gap1;
                }
                /* @gap2 */
                body .$unique_block_class .tds-input-wrap  {
                    margin: 0 0 @gap2;
                }
                body .$unique_block_class .tds-submit-btn {
                    margin: @gap2 0 0;
                }
                
                

                /* @input_padd */
                body .$unique_block_class .tds-input {
                    padding: @input_padd;
                }
                /* @input_border */
                body .$unique_block_class .tds-input {
                    border-width: @input_border;
                }
                /* @input_border_style */
                body .$unique_block_class .tds-input {
                    border-style: @input_border_style;
                }
                /* @input_radius */
                body .$unique_block_class .tds-input {
                    border-radius: @input_radius;
                }
                
                

                /* @btn_icon_size */
                body .$unique_block_class i.tds-submit-btn-icon {
                    font-size: @btn_icon_size;
                }
                body .$unique_block_class .tds-submit-btn-icon-svg {
                    width: @btn_icon_size;
                }
                /* @btn_icon_space_left */
                body .$unique_block_class .tds-submit-btn-icon {
                    margin-left: @btn_icon_space_left;
                }
                /* @btn_icon_space_right */
                body .$unique_block_class .tds-submit-btn-icon {
                    margin-right: @btn_icon_space_right;
                }
                /* @btn_icon_align */
                body .$unique_block_class .tds-submit-btn-icon {
                    top: @btn_icon_align;
                }
                
                /* @btn_padd */
                body .$unique_block_class .tds-submit-btn {
                    padding: @btn_padd;
                }
                /* @all_btn_border */
                body .$unique_block_class .tds-submit-btn {
                    border: @all_btn_border @all_btn_border_style @all_btn_border_color;
                }
                /* @btn_radius */
                body .$unique_block_class .tds-submit-btn {
                    border-radius: @btn_radius;
                }
                /* @btn_horiz_align */
                body .$unique_block_class .tds-submit-btn {
                    justify-content: @btn_horiz_align;
                }
                
                

                /* @pp_space */
                body .$unique_block_class .tds-checkbox {
                    margin-top: @pp_space;
                }             
                
                /* @pp_check_size */
                body .$unique_block_class .tds-checkbox label {
                    font-size: @pp_check_size;
                }
                /* @pp_check_space */
                body .$unique_block_class .tds-check {
                    margin-right: @pp_check_space;
                }
                /* @pp_check_radius */
                body .$unique_block_class .tds-check,
                body .$unique_block_class .tds-check:after {
                    border-radius: @pp_check_radius;
                }
                
                

                /* @title_color */
                body .$unique_block_class .tds-title {
                    color: @title_color;
                }  
                
                

                /* @msg_succ_color */
                body .$unique_block_class .tds-messages-success {
                    color: @msg_succ_color;
                }  
                /* @msg_succ_bg */
                body .$unique_block_class .tds-messages-success {
                    background-color: @msg_succ_bg;
                }  
                
                /* @msg_error_color */
                body .$unique_block_class .tds-messages-error {
                    color: @msg_error_color;
                } 
                /* @msg_err_bg */
                body .$unique_block_class .tds-messages-error {
                    background-color: @msg_err_bg;
                }  
                
                

                /* @input_color */
                body .$unique_block_class .tds-input {
                    color: @input_color;
                }  
                /* @input_place_color */
                body .$unique_block_class .tds-input::-webkit-input-placeholder {
                    color: @input_place_color;
                }
                body .$unique_block_class .tds-input::-moz-placeholder {
                    color: @input_place_color;
                }
                body .$unique_block_class .tds-input:-ms-input-placeholder {
                    color: @input_place_color;
                }
                body .$unique_block_class .tds-input:-moz-placeholder {
                    color: @input_place_color;
                }
                body .$unique_block_class .tds-input::placeholder {
                    color: @input_place_color;
                }
                /* @input_bg */
                body .$unique_block_class .tds-input {
                    background-color: @input_bg;
                }
                /* @input_bg_f */
                body .$unique_block_class .tds-input:focus {
                    background-color: @input_bg_f;
                }
                /* @input_border_color */
                body .$unique_block_class .tds-input {
                    border-color: @input_border_color;
                }
                /* @input_border_color_f */
                body .$unique_block_class .tds-input:focus {
                    border-color: @input_border_color_f;
                }
                
                

                /* @btn_color */
                body .$unique_block_class .tds-submit-btn {
                    color: @btn_color;
                }  
                body .$unique_block_class .tds-submit-btn-icon-svg svg {
                    fill: @btn_color;
                }
                /* @btn_color_h */
                body .$unique_block_class .tds-submit-btn:hover {
                    color: @btn_color_h;
                }  
                body .$unique_block_class .tds-submit-btn:hover .tds-submit-btn-icon-svg svg {
                    fill: @btn_color_h;
                }
                
                /* @btn_icon_color */
                body .$unique_block_class i.tds-submit-btn-icon {
                    color: @btn_icon_color;
                }  
                body .$unique_block_class .tds-submit-btn-icon-svg svg {
                    fill: @btn_icon_color;
                }
                /* @btn_icon_color_h */
                body .$unique_block_class .tds-submit-btn:hover i.tds-submit-btn-icon {
                    color: @btn_icon_color_h;
                }  
                body .$unique_block_class .tds-submit-btn:hover .tds-submit-btn-icon-svg svg {
                    fill: @btn_icon_color_h;
                }
                
                /* @btn_bg */
                body .$unique_block_class .tds-submit-btn {
                    background-color: @btn_bg;
                }  
                /* @btn_bg_h */
                body .$unique_block_class .tds-submit-btn:hover {
                    background-color: @btn_bg_h;
                }  
                
                /* @btn_border_color_h */
                body .$unique_block_class .tds-submit-btn:hover {
                    border-color: @btn_border_color_h;
                }  
                
                

                /* @pp_check_square */
                body .$unique_block_class .tds-check:after {
                    background-color: @pp_check_square;
                }  
                /* @pp_check_bg */
                body .$unique_block_class .tds-check {
                    background-color: @pp_check_bg;
                }  
                /* @pp_check_bg_c */
                body .$unique_block_class .tds-checkbox input:checked + label .tds-check {
                    background-color: @pp_check_bg_c;
                }  
                /* @pp_check_border_color */
                body .$unique_block_class .tds-check {
                    border-color: @pp_check_border_color;
                }  
                /* @pp_check_border_color_c */
                body .$unique_block_class .tds-checkbox input:checked + label .tds-check {
                    border-color: @pp_check_border_color_c;
                }  

                /* @pp_check_color */
                body .$unique_block_class .tds-check-title {
                    color: @pp_check_color;
                }  
                /* @pp_check_color_a */
                body .$unique_block_class .tds-check-title a {
                    color: @pp_check_color_a;
                }  
                /* @pp_check_color_a_h */
                body .$unique_block_class .tds-check-title a:hover {
                    color: @pp_check_color_a_h;
                }  
                
                

                /* @f_title */
                body .$unique_block_class .tds-title {
                    @f_title
                }  
                /* @f_msg */
                body .$unique_block_class .tds-message {
                    @f_msg
                }        
                /* @f_input */
                body .$unique_block_class .tds-input {
                    @f_input
                }      
                /* @f_btn */
                body .$unique_block_class .tds-submit-btn {
                    @f_btn
                }      
                /* @f_pp */
                body .$unique_block_class .tds-check-title {
                    @f_pp
                }              

            </style>";

		$td_css_res_compiler = new td_css_res_compiler( $raw_css );
		$td_css_res_compiler->load_settings( __CLASS__ . '::cssMedia', $this->get_all_atts() );

		$compiled_css .= $td_css_res_compiler->compile_css();

		return $compiled_css;

	}

	static function cssMedia( $res_ctx ) {

        $res_ctx->load_settings_raw( 'style_general_tds_leads', 1 );



        /*-- TITLE -- */
        // title space
        $title_space = $res_ctx->get_shortcode_att('title_space');
        $res_ctx->load_settings_raw('title_space', $title_space);
        if( $title_space != '' && is_numeric( $title_space ) ) {
            $res_ctx->load_settings_raw('title_space', $title_space . 'px');
        }



        /*-- MESSAGE -- */
        // message space
        $msg_space = $res_ctx->get_shortcode_att('msg_space');
        $res_ctx->load_settings_raw('msg_space', $msg_space);
        if( $msg_space != '' && is_numeric( $msg_space ) ) {
            $res_ctx->load_settings_raw('msg_space', $msg_space . 'px');
        }

        // message padding
        $msg_padd = $res_ctx->get_shortcode_att('msg_padd');
        $res_ctx->load_settings_raw('msg_padd', $msg_padd);
        if( $msg_padd != '' && is_numeric( $msg_padd ) ) {
            $res_ctx->load_settings_raw('msg_padd', $msg_padd . 'px');
        }

        // success messages border size
        $all_msg_succ_border = $res_ctx->get_shortcode_att('all_msg_succ_border');
        $res_ctx->load_settings_raw('all_msg_succ_border', $all_msg_succ_border);
        if( $all_msg_succ_border != '' && is_numeric( $all_msg_succ_border ) ) {
            $res_ctx->load_settings_raw('all_msg_succ_border', $all_msg_succ_border . 'px');
        }
        // success messages border style
        $res_ctx->load_settings_raw('all_msg_succ_border_style', $res_ctx->get_shortcode_att('all_msg_succ_border_style'));
        // success messages border radius
        $msg_succ_radius = $res_ctx->get_shortcode_att('msg_succ_radius');
        $res_ctx->load_settings_raw('msg_succ_radius', $msg_succ_radius);
        if( $msg_succ_radius != '' && is_numeric( $msg_succ_radius ) ) {
            $res_ctx->load_settings_raw('msg_succ_radius', $msg_succ_radius . 'px');
        }

        // error messages border size
        $all_msg_err_border = $res_ctx->get_shortcode_att('all_msg_err_border');
        $res_ctx->load_settings_raw('all_msg_err_border', $all_msg_err_border);
        if( $all_msg_err_border != '' && is_numeric( $all_msg_err_border ) ) {
            $res_ctx->load_settings_raw('all_msg_err_border', $all_msg_err_border . 'px');
        }
        // error messages border style
        $res_ctx->load_settings_raw('all_msg_err_border_style', $res_ctx->get_shortcode_att('all_msg_err_border_style'));
        // error messages border radius
        $msg_err_radius = $res_ctx->get_shortcode_att('msg_err_radius');
        $res_ctx->load_settings_raw('msg_err_radius', $msg_err_radius);
        if( $msg_err_radius != '' && is_numeric( $msg_err_radius ) ) {
            $res_ctx->load_settings_raw('msg_err_radius', $msg_err_radius . 'px');
        }



        /*-- INPUT & BUTTON -- */
        // display
        $display = $res_ctx->get_shortcode_att('display');
        $res_ctx->load_settings_raw('display', $display);

        // gap
        $gap = $res_ctx->get_shortcode_att('gap');
        if( $gap != '' && is_numeric( $gap ) ) {
            if( $display == 'row' || $display == '' ) {
                $res_ctx->load_settings_raw('gap1', ( $gap / 2 ) . 'px');
            } else {
                $res_ctx->load_settings_raw('gap2', ( $gap / 2 ) . 'px');
            }
        }



        /*-- INPUT -- */
        // input padding
        $input_padd = $res_ctx->get_shortcode_att('input_padd');
        $res_ctx->load_settings_raw('input_padd', $input_padd);
        if( $input_padd != '' && is_numeric( $input_padd ) ) {
            $res_ctx->load_settings_raw('input_padd', $input_padd . 'px');
        }

        // input border size
        $input_border = $res_ctx->get_shortcode_att('input_border');
        $res_ctx->load_settings_raw('input_border', $input_border);
        if( $input_border != '' && is_numeric( $input_border ) ) {
            $res_ctx->load_settings_raw('input_border', $input_border . 'px');
        }

        // input border style
        $res_ctx->load_settings_raw('input_border_style', $res_ctx->get_shortcode_att('input_border_style'));

        // input border radius
        $input_radius = $res_ctx->get_shortcode_att('input_radius');
        $res_ctx->load_settings_raw('input_radius', $input_radius);
        if( $input_radius != '' && is_numeric( $input_radius ) ) {
            $res_ctx->load_settings_raw('input_radius', $input_radius . 'px');
        }



        /*-- BUTTON -- */
        $btn_icon_pos = $res_ctx->get_shortcode_att('btn_icon_pos');

        // button icon size
        $btn_icon_size = $res_ctx->get_shortcode_att('btn_icon_size');
        $res_ctx->load_settings_raw('btn_icon_size', $btn_icon_size);
        if( $btn_icon_size != '' && is_numeric( $btn_icon_size ) ) {
            $res_ctx->load_settings_raw('btn_icon_size', $btn_icon_size . 'px');
        }

        // button icon space
        $btn_icon_space = $res_ctx->get_shortcode_att('btn_icon_space');
        if( $btn_icon_pos == '' || $btn_icon_pos == 'after' ) {
            if( $btn_icon_space != '' ) {
                if( is_numeric( $btn_icon_space ) ) {
                    $res_ctx->load_settings_raw('btn_icon_space_left', $btn_icon_space . 'px');
                } else {
                    $res_ctx->load_settings_raw('btn_icon_space_left', $btn_icon_space);
                }
            } else {
                $res_ctx->load_settings_raw('btn_icon_space_left', '8px');
            }
        } else {
            if( $btn_icon_space != '' ) {
                if( is_numeric( $btn_icon_space ) ) {
                    $res_ctx->load_settings_raw('btn_icon_space_right', $btn_icon_space . 'px');
                } else {
                    $res_ctx->load_settings_raw('btn_icon_space_right', $btn_icon_space);
                }
            } else {
                $res_ctx->load_settings_raw('btn_icon_space_right', '8px');
            }
        }

        // button icon align
        $res_ctx->load_settings_raw('btn_icon_align', $res_ctx->get_shortcode_att('btn_icon_align') . 'px');

        // button padding
        $btn_padd = $res_ctx->get_shortcode_att('btn_padd');
        $res_ctx->load_settings_raw('btn_padd', $btn_padd);
        if( $btn_padd != '' && is_numeric( $btn_padd ) ) {
            $res_ctx->load_settings_raw('btn_padd', $btn_padd . 'px');
        }

        // button border size
        $all_btn_border = $res_ctx->get_shortcode_att('all_btn_border');
        $res_ctx->load_settings_raw('all_btn_border', $all_btn_border);
        if( $all_btn_border != '' && is_numeric( $all_btn_border ) ) {
            $res_ctx->load_settings_raw('all_btn_border', $all_btn_border . 'px');
        }

        // button border style
        $res_ctx->load_settings_raw('all_btn_border_style', $res_ctx->get_shortcode_att('all_btn_border_style'));

        // button border radius
        $btn_radius = $res_ctx->get_shortcode_att('btn_radius');
        $res_ctx->load_settings_raw('btn_radius', $btn_radius);
        if( $btn_radius != '' && is_numeric( $btn_radius ) ) {
            $res_ctx->load_settings_raw('btn_radius', $btn_radius . 'px');
        }

        // button horizontal align
        $btn_horiz_align = $res_ctx->get_shortcode_att('btn_horiz_align');
        if( $btn_horiz_align == 'content-horiz-left' ) {
            $res_ctx->load_settings_raw('btn_horiz_align', 'flex-start');
        } else if( $btn_horiz_align == 'content-horiz-center' ) {
            $res_ctx->load_settings_raw('btn_horiz_align', 'center');
        } else if( $btn_horiz_align == 'content-horiz-right' ) {
            $res_ctx->load_settings_raw('btn_horiz_align', 'flex-end');
        }



        /*-- PRIVACY POLICY -- */
        // pp top space
        $pp_space = $res_ctx->get_shortcode_att('pp_space');
        $res_ctx->load_settings_raw('pp_space', $pp_space);
        if( $pp_space != '' && is_numeric( $pp_space ) ) {
            $res_ctx->load_settings_raw('pp_space', $pp_space . 'px');
        }

        // checkbox size
        $res_ctx->load_settings_raw('pp_check_size', $res_ctx->get_shortcode_att('pp_check_size') . 'px');
        // checkbox space
        $pp_check_space = $res_ctx->get_shortcode_att('pp_check_space');
        $res_ctx->load_settings_raw('pp_check_space', $pp_check_space);
        if( $pp_check_space != '' && is_numeric( $pp_check_space ) ) {
            $res_ctx->load_settings_raw('pp_check_space', $pp_check_space . 'px');
        }
        // checkbox border radius
        $pp_check_radius = $res_ctx->get_shortcode_att('pp_check_radius');
        $res_ctx->load_settings_raw('pp_check_radius', $pp_check_radius);
        if( $pp_check_radius != '' && is_numeric( $pp_check_radius ) ) {
            $res_ctx->load_settings_raw('pp_check_radius', $pp_check_radius . 'px');
        }



        /*-- COLORS -- */
        $res_ctx->load_settings_raw('title_color', $res_ctx->get_shortcode_att('title_color'));

        $res_ctx->load_settings_raw('msg_succ_color', $res_ctx->get_shortcode_att('msg_succ_color'));
        $res_ctx->load_settings_raw('msg_succ_bg', $res_ctx->get_shortcode_att('msg_succ_bg'));
        $all_msg_succ_border_color = $res_ctx->get_shortcode_att('all_msg_succ_border_color');
        if( $all_msg_succ_border_color != '' ) {
            $res_ctx->load_settings_raw('all_msg_succ_border_color', $all_msg_succ_border_color);
        } else {
            $res_ctx->load_settings_raw('all_msg_succ_border_color', '#000');
        }

        $res_ctx->load_settings_raw('msg_error_color', $res_ctx->get_shortcode_att('msg_error_color'));
        $res_ctx->load_settings_raw('msg_err_bg', $res_ctx->get_shortcode_att('msg_err_bg'));
        $all_msg_err_border_color = $res_ctx->get_shortcode_att('all_msg_err_border_color');
        if( $all_msg_err_border_color != '' ) {
            $res_ctx->load_settings_raw('all_msg_err_border_color', $all_msg_err_border_color);
        } else {
            $res_ctx->load_settings_raw('all_msg_err_border_color', '#000');
        }

        $res_ctx->load_settings_raw('input_color', $res_ctx->get_shortcode_att('input_color'));
        $res_ctx->load_settings_raw('input_place_color', $res_ctx->get_shortcode_att('input_place_color'));
        $res_ctx->load_settings_raw('input_bg', $res_ctx->get_shortcode_att('input_bg'));
        $res_ctx->load_settings_raw('input_bg_f', $res_ctx->get_shortcode_att('input_bg_f'));
        $res_ctx->load_settings_raw('input_border_color', $res_ctx->get_shortcode_att('input_border_color'));
        $res_ctx->load_settings_raw('input_border_color_f', $res_ctx->get_shortcode_att('input_border_color_f'));

        $res_ctx->load_settings_raw('btn_color', $res_ctx->get_shortcode_att('btn_color'));
        $res_ctx->load_settings_raw('btn_color_h', $res_ctx->get_shortcode_att('btn_color_h'));
        $res_ctx->load_settings_raw('btn_icon_color', $res_ctx->get_shortcode_att('btn_icon_color'));
        $res_ctx->load_settings_raw('btn_icon_color_h', $res_ctx->get_shortcode_att('btn_icon_color_h'));
        $res_ctx->load_settings_raw('btn_bg', $res_ctx->get_shortcode_att('btn_bg'));
        $res_ctx->load_settings_raw('btn_bg_h', $res_ctx->get_shortcode_att('btn_bg_h'));
        $all_btn_border_color = $res_ctx->get_shortcode_att('all_btn_border_color');
        if( $all_btn_border_color != '' ) {
            $res_ctx->load_settings_raw('all_btn_border_color', $all_btn_border_color);
        } else {
            $res_ctx->load_settings_raw('all_btn_border_color', '#000');
        }
        $res_ctx->load_settings_raw('btn_border_color_h', $res_ctx->get_shortcode_att('btn_border_color_h'));

        $res_ctx->load_settings_raw('pp_check_square', $res_ctx->get_shortcode_att('pp_check_square'));
        $res_ctx->load_settings_raw('pp_check_bg', $res_ctx->get_shortcode_att('pp_check_bg'));
        $res_ctx->load_settings_raw('pp_check_bg_c', $res_ctx->get_shortcode_att('pp_check_bg_c'));
        $res_ctx->load_settings_raw('pp_check_border_color', $res_ctx->get_shortcode_att('pp_check_border_color'));
        $res_ctx->load_settings_raw('pp_check_border_color_c', $res_ctx->get_shortcode_att('pp_check_border_color_c'));
        $res_ctx->load_settings_raw('pp_check_color', $res_ctx->get_shortcode_att('pp_check_color'));
        $res_ctx->load_settings_raw('pp_check_color_a', $res_ctx->get_shortcode_att('pp_check_color_a'));
        $res_ctx->load_settings_raw('pp_check_color_a_h', $res_ctx->get_shortcode_att('pp_check_color_a_h'));



        /*-- FONTS -- */
        $res_ctx->load_font_settings( 'f_title' );
        $res_ctx->load_font_settings( 'f_msg' );
        $res_ctx->load_font_settings( 'f_input' );
        $res_ctx->load_font_settings( 'f_btn' );
        $res_ctx->load_font_settings( 'f_pp' );

	}

	function __construct() {
		parent::disable_loop_block_features();
	}

	function render( $atts, $content = null ) {

		//echo '<pre><span style="font-weight: bold; color: orangered;">block atts:</span>';
		//echo PHP_EOL;
		//print_r($atts);
		//echo '</pre>';
		//return;

		parent::render( $atts );

        /* -- mailing list -- */
        $tds_list = $this->get_att('list');

        /* -- message -- */
        // show in composer
        $message_composer = $this->get_att('msg_composer');

        // position
        $message_pos = $this->get_att('msg_pos');

        // text
        $message = '';
        if( tdc_state::is_live_editor_ajax() || tdc_state::is_live_editor_iframe() ) {
            if( $message_composer == 'success' ) {
                $message .= '<div class="tds-messages tds-messages-success">';
                    $message .= '<div class="tds-message">Success!</div>';
                $message .= '</div>';
            } else if( $message_composer == 'error' ) {
                $message .= '<div class="tds-messages tds-messages-error">';
                    $message .= '<div class="tds-message">Error message</div>';
                    $message .= '<div class="tds-message">Another error message</div>';
                $message .= '</div>';
            }
        } else {
            if ( td_subscription::instance()->is_tds_form_submit() ) { // check if form was submitted

                if( tds_form_submission::has_errors() ) {
                    $tds_form_submission_errors = tds_form_submission::get_errors();
                    //$message .= '<pre>';
                    //$message .= print_r( $tds_form_submission_errors, true );
                    //$message .= '</pre>';
                    $message .= '<div class="tds-messages tds-messages-error">';
                        foreach( $tds_form_submission_errors as $err_id => $err_msg ) {
                            //if ( $err_id === 'email_found_in_list' )
                            //continue; // no message for emails already found in list
                            $message .= '<div class="tds-message">' . $err_msg . '</div>';
                        }
                    $message .= '</div>';
                } else {
                    $tds_form_submission_results = tds_form_submission::get_result();
                    //$message .= '<pre>';
                    //$message .= print_r( $tds_form_submission_results, true );
                    //$message .= '</pre>';
                    $message .= '<div class="tds-messages tds-messages-success">';
                        $message .= '<div class="tds-message">Success!</div>';
                    $message .= '</div>';
                }
            }
        }

        /* -- title -- */
        // text
		$title_text = $this->get_att('title_text' );

		// tag
        $title_tag = $this->get_att('title_tag');
        if( $title_tag == '' ) {
            $title_tag = 'h3';
        }

		/* -- input -- */
		$input_placeholder = $this->get_att('input_placeholder' );

        /* -- button -- */
        // text
		$btn_text = $this->get_att('btn_text');
		if( $btn_text == '' ) {
		    $btn_text = 'Subscribe';
        }

		// icon
        $btn_icon = $this->get_icon_att( 'btn_tdicon' );
		$btn_icon_html = '';
		if( $btn_icon != '' ) {
            if( base64_encode( base64_decode( $btn_icon ) ) == $btn_icon ) {
                $btn_icon_html = '<span class="tds-submit-btn-icon tds-submit-btn-icon-svg">' . base64_decode( $btn_icon ) . '</span>';
            } else {
                $btn_icon_html = '<i class="tds-submit-btn-icon ' . $btn_icon . '"></i>';
            }
        }

		// icon position
        $btn_icon_pos = $this->get_att('btn_icon_pos');

        /* -- privacy policy -- */
        // checkbox
        $pp_checkbox = $this->get_att('pp_checkbox');

        // message
		$pp_msg = rawurldecode( base64_decode( strip_tags( $this->get_att('pp_msg') ) ) );
        $pp_msg = td_util::parse_footer_texts($pp_msg);

        // redirect url
        $successful_submit_rdr_url = $this->get_att('successful_submit_rdr_url');

		$buffy = '<div class="' . $this->get_block_classes() . '" ' . $this->get_block_html_atts() . '>';

			$buffy .= $this->get_block_css(); // get block css
			$buffy .= $this->get_block_js(); // get block js

			$buffy .= '<div class="tds-block-inner td-fix-index">';

                // js render
                ob_start();
                ?>
                    <script>

                        jQuery().ready(function () {

                            var tdsLeadsItem = new tdsLeads.item();

                            // block unique ID
                            tdsLeadsItem.blockUid = '<?php echo $this->block_uid; ?>';
                            //tdsLeadsItem.blockAtts = '<?php //echo json_encode( $this->get_all_atts(), JSON_UNESCAPED_SLASHES ); ?>//';
                            tdsLeadsItem.jqueryObj = jQuery('.<?php echo $this->block_uid ?>');

                            <?php if ( tdc_state::is_live_editor_ajax() || tdc_state::is_live_editor_iframe() ) { ?>
                                tdsLeadsItem.inComposer = true;
                            <?php } ?>

                            <?php if ( td_subscription::instance()->is_tds_form_submit() ) { ?>
                                tdsLeadsItem.isSubmit = true;

                                <?php if ( tds_form_submission::has_errors() ) { ?>
                                    tdsLeadsItem.submitHasErrors = true;

                                    <?php if ( !( tdc_state::is_live_editor_ajax() && tdc_state::is_live_editor_iframe() ) ) { ?>
                                        var errorMessages = jQuery('.<?php echo $this->block_uid ?> .tds-messages');

                                        if( errorMessages.length ) {
                                            setTimeout(function () {
                                                errorMessages.addClass('tds-messages-hiding');

                                                setTimeout(function () {
                                                    errorMessages.remove();
                                                }, 300);
                                            }, 3000);
                                        }
                                    <?php } ?>
                                <?php } ?>
                            <?php } ?>

                            tdsLeads.addItem( tdsLeadsItem );

                        });

                    </script>
                <?php
                td_js_buffer::add_to_footer("\n" . td_util::remove_script_tag( ob_get_clean() ) );

                /* title display */
                if( $title_text != '' ) {
                    $buffy .= '<' . $title_tag . ' class="tds-title">' . $title_text . '</' . $title_tag . '>';
                }

                /* message display */
                if( ($message_pos == '' || $message_pos == 'title') ) {
                    $buffy .= '<div class="tds-info">';
                        if( $message != '' ) {
                            $buffy .= $message;
                        }
                    $buffy .= '</div>';
                }


                /* form */
                $buffy .= '<form class="tds-form" action="" method="post" name="">';

                    $buffy .= '<div class="tds-email-bar">';

                        $buffy .= '<div class="tds-input-wrap">';
                            /* email input */
                            $buffy .= '<input class="tds-input" type="email" name="email" aria-label="email" placeholder="' . $input_placeholder . '">';
                            /* list input */
                            $buffy .= '<input type="hidden" name="list" value="' . $tds_list . '">';
                            /* redirect url */
                            if ( !empty( $successful_submit_rdr_url ) ) {
                                $buffy .= '<input type="url" name="rdr_url" value="' . $successful_submit_rdr_url . '" style="display: none;">';
                            }
                        $buffy .= "</div>";

                        /* button */
                        $buffy .= '<button class="tds-submit-btn" type="submit" name="tds-subscribe">';
                            if( $btn_icon_pos == 'before' && $btn_icon_html != '' ) {
                                $buffy .= $btn_icon_html;
                            }

                            $buffy .= $btn_text;

                            if( ( $btn_icon_pos == 'after' || $btn_icon_pos == '' ) && $btn_icon_html != '' ) {
                                $buffy .= $btn_icon_html;
                            }
                        $buffy .= '</button>';

                    $buffy .= "</div>";


                    /* privacy policy checkbox */
                    if ( $pp_checkbox != '' && $pp_msg != '' ) {
                        $buffy .= '<div class="tds-checkbox">';
                            $buffy .= '<input id="pp_checkbox_' . $this->block_uid . '" class="" name="" value="Y" type="checkbox">';
                            $buffy .= '<label class="checkbox subfield" for="pp_checkbox_' . $this->block_uid . '">';
                                $buffy .= '<span class="tds-check"></span>';
                                $buffy .= '<span class="tds-check-title">' . $pp_msg . '</span>';
                            $buffy .= '</label>';
                        $buffy .= '</div>';
                    }

                $buffy .= "</form>";


                /* message display */
                if( $message_pos == 'form' ) {
                    $buffy .= '<div class="tds-info">';
                        if( $message != '' ) {
                            $buffy .= $message;
                        }
                    $buffy .= '</div>';
                }

            $buffy .= '</div>';

		$buffy .= '</div>';

		return $buffy;
	}

}