<?php
/**
 * td-subscription setup
 */

defined( 'ABSPATH' ) || exit;

class td_subscription {

	// single class instance
	protected static $_instance = null;

	// main td-subscription instance, ensures single load
	public static function instance() {
		if ( is_null( self::$_instance ) ) {
			self::$_instance = new self();
		}
		return self::$_instance;
	}

	// td_subscription constructor
	public function __construct() {
		$this->includes();
		$this->init();
	}

	// includes
	private function includes() {

		// load api
		require_once('tds_api.php');

		// load the utility class
		require_once "tds_util.php";

		// load config
		require_once "tds_config.php";

		// preview ajax ( rest api )
		require_once('tds_ajax.php');

		// admin
		if ( $this->is_request( 'admin' ) ) {

			// admin class
			require_once('admin/tds_admin.php');

		}

		// frontend
		if ( $this->is_request( 'frontend' ) ) {

			// load email locker
			require_once('frontend/tds_email_locker.php'); // @todo add in directory > email-locker/ ???

		}

		// load tds form submission class
		if ( $this->is_request( 'tds-leads-form-submit' ) ) {
			require_once('tds_form_submission.php');
		}

	}

	// init
	private function init() {

		// load cpt
		add_action( 'init', array( __CLASS__, 'setup_environment' ) );

		// load plugin config/shortcodes
		add_action( 'tdc_loaded', array( 'tds_config', 'on_tdc_loaded' ), 10 );

		// email submission
		//if ( $this->is_request( 'tds-leads-form-submit' ) ) {}

		// load scripts
		add_action( 'wp_enqueue_scripts', function () {

			// load form submission js
			//if ( $this->is_request( 'tds-leads-form-submit' ) ) {
			//
			//	wp_register_script('tds-leads-form-submit', TDS_URL . '/assets/js/frontend/leads-form-submit.js', array( 'jquery' ), TD_SUBSCRIPTION, true );
			//	wp_enqueue_script('tds-leads-form-submit');
			//	wp_localize_script('tds-leads-form-submit','tds_leads_form_submit_data',
			//		array(
			//			'has_errors' => tds_form_submission::has_errors(),
			//			'errors' => tds_form_submission::get_errors(),
			//			'result' => tds_form_submission::get_result()
			//		)
			//	);
			//
			//}

			// load front js
			if ( $this->is_request( 'frontend' ) ) {

				if ( class_exists( 'tdc_util', false ) ) {
					tdc_util::enqueue_js_files_array( tds_config::$js_files_for_front, array( 'jquery', 'underscore' ), TDS_URL, TD_SUBSCRIPTION );
				} else {

					foreach ( tds_config::$js_files_for_front as $js_file_id => $js_file_url ) {
						wp_enqueue_script( $js_file_id, TDS_URL . $js_file_url, array( 'jquery', 'underscore' ), TDS_URL, true );
					}

				}

			}

		});

		// on activate..
		register_activation_hook( TDS_PLUGIN_FILE, function () {

			// register the cpt & tax
			self::setup_environment();

			// add the default locker
			self::add_default_locker(
				'tds_default_locker_id',
				array(
					'post_type' => 'tds_locker',
					'post_title' => 'Locker (default)',
					'post_name' => 'tds_default_locker'
				),
				array(
					'tds_locker_settings' => array(
						'tds_title' => 'This Content Is Only For Subscribers',
						'tds_message' => 'Please subscribe to unlock this content. Enter your email to get access.',
						'tds_input_placeholder' => 'Please enter your email address.',
						'tds_submit_btn_text' => 'Subscribe to unlock',
						'tds_after_btn_text' => 'Your email address is 100% safe from spam!',
						'tds_pp_msg' => 'I consent to processing of my data according to <a href="#">Terms of Use</a> & <a href="#">Privacy Policy</a>'
					),
					'tds_locker_preview' => array(),
					'tds_locker_access_settings' => array(
						'tds_locker_email_list' => get_option( 'default_term_tds_list' )
					),
				)
			);

			flush_rewrite_rules();  // and... flush

		});

		// on deactivate..
		register_deactivation_hook( __FILE__, 'flush_rewrite_rules' ); // flush permalinks

		// exclude tds_email cpt from theme's cpt support
		add_filter( 'td_custom_post_types', function ( $td_cpts ) {
			$tds_email = array_search('tds_email', $td_cpts );
			if( $tds_email !== false ) {
				unset($td_cpts[$tds_email]);
			}
			$tds_locker = array_search('tds_locker', $td_cpts );
			if( $tds_locker !== false ) {
				unset($td_cpts[$tds_locker]);
			}
			return $td_cpts;
		}, 10, 1 );

		// add locker settings tab to theme post settings metabox
		add_filter( 'td_post_settings_tabs', function ( $td_post_settings_tabs ) {
			return array_merge(
				$td_post_settings_tabs,
				array(
					// tab_id => tab data array
					array(
						'id' => 'tds_locker',
						'name' => 'Locker',
						'file' => TDS_PATH . '/includes/admin/metaboxes/tds_post_locker_settings.php',
					)
				)
			);
		}, 10, 1 );

		// on admin
		if ( $this->is_request( 'admin' ) ) {

			// enqueue admin js/css
			add_action( 'admin_enqueue_scripts', function () {

				// css for wp-admin/backend
				if ( TDS_DEPLOY_MODE == 'dev' ) {
					wp_enqueue_style( 'tds-admin', TDS_URL . '/td_less_style.css.php?part=tds_admin_main', false, TD_SUBSCRIPTION );
				} else {
					wp_enqueue_style('tds-admin', TDS_URL . '/assets/css/tds-admin.css', false, TD_SUBSCRIPTION );
				}

			});

			// change view link in tds list taxonomies list table
			add_filter( 'term_link', function ( $termlink, $term, $taxonomy ) {

				// get the current screen
				$current_screen = get_current_screen();

				if ( $taxonomy === 'tds_list' && $current_screen->id === 'edit-tds_list' ) {

					$path = 'edit.php?post_type=tds_email&tds_list=' . $term->slug;
					$termlink = admin_url($path);

				}

				return $termlink;

			}, 10, 3 );

			// add filter support on wp-admin tds_email cpt list
			add_action( 'restrict_manage_posts', function ( $post_type ) {

				if ( 'tds_email' === $post_type ) {

					// output select html for emails lists dropdown filter
					echo '<select name="tds_list" id="tds_list" class="postform">';
					echo '<option value="">All Lists</option>';

					$tds_lists = get_terms(
						array(
							'taxonomy' => 'tds_list',
							'hide_empty' => false,
						)
					);

					foreach ( $tds_lists as $list ) {
						$selected = $_GET['tds_list'] ?? null;
						echo '<option value='. $list->slug, $selected == $list->slug ? ' selected="selected"' : '','>' . $list->name .'</option>';
					}

					echo "</select>";

				}

			});

			// add export leads csv button via admin notices hook
			add_action( 'admin_notices', function () {

				// get the current screen
				$current_screen = get_current_screen();

				// return if it's not the emails listing page
				if ( !isset( $current_screen->id ) || $current_screen->id !== 'edit-tds_email' )
					return;

				// build & display download button
				$url = admin_url('edit.php');
				global $wp;
				$query = $wp->query_string;
				if ( $query ) {
					$url .= '?' . $query . '&tds_action=download_csv_file';
					echo '<a href="' . $url . '" class="button button-primary button-lg csv-download-button" style="margin-top: 20px;" >Download CSV file</a>';
				}

			});

			// handle export csv download btn action ..on current_screen
			add_action( 'current_screen', function ( $current_screen ) {

				if ( isset( $current_screen->id ) && $current_screen->id === 'edit-tds_email' ) {

					// hook later.. after wp env setup to have access to wp query
					add_action( 'wp', function () {

						if ( isset( $_GET['tds_action'] ) && $_GET['tds_action'] == 'download_csv_file' ) {

							global $wp_query;

							// query
							$emails = $wp_query->get_posts();

							// file creation
							$wp_filename = "tds_leads_" . date("d-m-y") . ".csv";

							// clean object
							ob_end_clean();

							// open file
							$wp_file = fopen( $wp_filename, "w" );

							// loop for insert data into csv file
							foreach ( $emails as $email ) {
								$list = wp_get_post_terms( $email->ID, 'tds_list' );
								$wp_array = array(
									"id"            => $email->ID,
									"date_created"  => $email->post_date,
									"email"         => $email->post_title,
									"list"          => implode( ',', array_column( $list, 'name' ) ),
								);
								fputcsv( $wp_file, $wp_array );
							}

							// close file
							fclose($wp_file);

							// download csv file
							header("Content-Description: File Transfer");
							header("Content-Disposition: attachment; filename=" . $wp_filename);
							header("Content-Type: application/csv;");
							readfile( $wp_filename );

							exit;

						}

					});

				}

			});

			// admin menu
			add_action( 'admin_menu', array( __CLASS__, 'admin_menu' ) );

		}

		// add locked articles(posts) filter to cloud library loop blocks @see tdb_config::get_loop_map_filter_array()
		add_filter( 'td_cloud_library_loop_map_filter_array', array( __CLASS__, 'add_locked_posts_filter' ), 10, 2 );

		// add locked articles(posts) filter to td composer flex/big grid/slide blocks @see td_config::get_map_filter_array()
		add_filter( 'td_composer_map_filter_array', array( __CLASS__, 'add_locked_posts_filter' ), 10, 2 );

		// add locked articles(posts) filter wp query args to blocks @see td_data_source::get_wp_query()
		add_filter( 'td_data_source_blocks_query_args', array( __CLASS__, 'add_locked_posts_filter_args' ), 10, 2 );

        // add exclusive label to td composer flex/big grid/slide modules @see td_config::get_map_exclusive_label_array()
        add_filter( 'td_composer_map_exclusive_label_array', array( __CLASS__, 'add_exclusive_label_settings' ), 10, 4 );

        // add 'exclsive' class to td composer flex modules
        add_filter( 'td_composer_module_exclusive_class', array( __CLASS__, 'add_exclusive_class_on_modules' ), 10, 2 );

        // add 'exclsive' class to cloud library modules
        add_filter( 'td_cloud_library_module_exclusive_class', array( __CLASS__, 'add_exclusive_class_on_cloud_modules' ), 10, 2 );

		// add the save_filter callback option on post theme settings metabox..
		add_filter( 'td_post_theme_settings_mb_setup_options', array( __CLASS__, 'add_mb_setup_options' ) );

	}

	/**
	 * type of request
	 *
	 * @param  string $type admin, ajax, cron, frontend or tds-leads-form-submit
	 * @return bool
	 */
	private function is_request( $type ) {

		switch ( $type ) {
			case 'admin':
				return is_admin();
			case 'ajax':
				return defined( 'DOING_AJAX' );
			case 'cron':
				return defined( 'DOING_CRON' );
			case 'frontend':
				return ( !is_admin() || defined( 'DOING_AJAX' ) ) &&
				       !defined( 'DOING_CRON' ) &&
				       !$this->is_rest_api_request();
			case 'tds-leads-form-submit':
				return $this->is_tds_form_submit();
		}

		return false;
	}

	/**
	 * returns true if the request is a non-legacy Rest api request
	 * @return bool
	 */
	public function is_rest_api_request() {

		if ( empty( $_SERVER['REQUEST_URI'] ) ) {
			return false;
		}

		$rest_prefix = trailingslashit( rest_get_url_prefix() );

		return ( false !== strpos( $_SERVER['REQUEST_URI'], $rest_prefix ) );
	}

	/**
	 * returns true if it's a submit for the tds_leads shortcode email form submit
	 * @return bool
	 */
	public function is_tds_form_submit() {
		return isset( $_POST['tds-subscribe'] );
	}

	/**
	 * setup tds environment - post types, taxonomies, endpoints
	 */
	public static function setup_environment() {

		// register email lists tax
		self::register_taxonomy();

		// register email post type
		self::register_post_type(
			'tds_email',
			array(
				'public' => true,
				'label'  => 'Leads - Emails',
				'labels'  => array(
					'name'               => 'Leads - Emails',
					'singular_name'      => 'Leads - Email',
					'menu_name'          => 'Leads - Emails',
					'name_admin_bar'     => 'Leads - Email',
					'add_new'            => 'Add New',
					'add_new_item'       => 'Add New Email',
					'new_item'           => 'New Email',
					'edit_item'          => 'Edit Email',
					'all_items'          => 'Leads - Emails',
					'search_items'       => 'Search Emails',
					'not_found'          => 'No emails found.',
					'not_found_in_trash' => 'No emails found in Trash.'
				),
				'supports' => array( 'title' ),
				'show_in_admin_bar' => false,
				'show_in_nav_menus' => false,
				'publicly_queryable' => false,
				'hierarchical' => false,
				'exclude_from_search' => true,
				'capabilities' => array(
					//'create_posts' => 'do_not_allow'
				)
			)
		);

		// register locker post type
		self::register_post_type(
			'tds_locker',
			array(
				'public' => true,
				'label'  => 'Lockers',
				'labels'  => array(
					'name'               => 'Lockers',
					'singular_name'      => 'Locker',
					'menu_name'          => 'Lockers',
					'name_admin_bar'     => 'Locker',
					'add_new'            => 'Add New',
					'add_new_item'       => 'Add New Locker',
					'new_item'           => 'New Locker',
					'edit_item'          => 'Edit Locker',
					'all_items'          => 'Lockers',
					'search_items'       => 'Search Lockers',
					'not_found'          => 'No lockers found.',
					'not_found_in_trash' => 'No lockers found in Trash.'
				),
				'supports' => array( 'title' ),
				'show_in_admin_bar' => false,
				'show_in_nav_menus' => false,
				'show_in_menu' => 'edit.php?post_type=tds_email',
				'publicly_queryable' => false,
				'hierarchical' => false,
				'exclude_from_search' => true,
			)
		);

		// add default locker
		//self::add_default_locker(
		//	'tds_default_locker_id',
		//	array(
		//		'post_type' => 'tds_locker',
		//		'post_title' => 'Locker (default)',
		//		'post_name' => 'tds_default_locker'
		//	),
		//	array(
		//		'tds_locker_settings' => array(
		//			'tds_title' => 'This Content Is Only For Subscribers',
		//			'tds_message' => 'Please subscribe to unlock this content. Enter your email to get access.',
		//			'tds_input_placeholder' => 'Please enter your email address.',
		//			'tds_submit_btn_text' => 'Subscribe to unlock',
		//			'tds_after_btn_text' => 'Your email address is 100% safe from spam!',
		//			'tds_pp_msg' => 'I consent to processing of my data according to <a href="#">Terms of Use</a> & <a href="#">Privacy Policy</a>'
		//		),
		//		'tds_locker_preview' => array(),
		//		'tds_locker_access_settings' => array(
		//			'tds_locker_email_access' => get_option( 'default_term_tds_list' )
		//		),
		//	)
		//);

		// @todo add api endpoints here ???

	}

	/**
	 * register core post types
	 */
	public static function register_post_type( $name, $options ) {

		if ( post_type_exists($name) ) {
			return;
		}

		register_post_type( $name, $options );

	}

	/**
	 * register core taxonomy
	 */
	public static function register_taxonomy() {

		if ( taxonomy_exists( 'tds_list' ) ) {
			return;
		}

		/**
		 * Add new taxonomy, NOT hierarchical (like tags)  and associate it to the tds_email (lead) custom post type
		 * https://developer.wordpress.org/reference/functions/register_taxonomy/
		 */
		$tds_list_labels = array(
			'name'                       => 'Leads - Lists',
			'singular_name'              => 'Leads - List',
			'search_items'               => 'Search Lists',
			'all_items'                  => 'All Lists',
			'parent_item'                => null,
			'parent_item_colon'          => null,
			'edit_item'                  => 'Edit List',
			'update_item'                => 'Update List',
			'add_new_item'               => 'Add New List',
			'new_item_name'              => 'New List Name',
			'add_or_remove_items'        => 'Add or remove lists',
			'not_found'                  => 'No lists found.',
			'menu_name'                  => 'Leads - Lists',
		);
		$args = array(
			'hierarchical'          => true,
			'labels'                => $tds_list_labels,
			'show_ui'               => true,
			'show_admin_column'     => true,
			'query_var'             => true,
			'default_term'          => 'Default List',
			'rewrite'               => array( 'slug' => 'tds_list' ),
		);
		register_taxonomy( 'tds_list', 'tds_email', $args );

	}

	/**
	 * adds locker on activation
	 *
	 * @param string $default_locker_option_id - option id
	 * @param array $post_info - post info
	 * @param array $post_meta - post meta data
	 */
	public static function add_default_locker( $default_locker_option_id, $post_info, $post_meta ) {

		global $wpdb;

		$slug = $post_info['post_name'];
		$post_type = $post_info['post_type'];

		$id = $wpdb->get_var("SELECT ID FROM " . $wpdb->posts . " WHERE post_name = '$slug' AND 
                    post_type = '" . $post_type . "' LIMIT 1");

		$default_locker_option_val = get_option( $default_locker_option_id );

		if ( !$id ) {
			$create = true;

			if ( !empty( $default_locker_option_val ) ) {
				$post_id = $wpdb->get_var("SELECT ID FROM " . $wpdb->posts . " WHERE ID = '$default_locker_option_val' AND 
                            post_type = '" . $post_type . "' LIMIT 1");
				if ( $post_id ) {
					$create = false;
				}

			}

			if ( $create ) {
				if ( !isset( $post_info['post_status'] ) ) {
					$post_info['post_status'] = 'publish';
				}

				// '@' here is to hide unexpected output while plugin activation
				$optionValue = @wp_insert_post( $post_info );
				$id = $optionValue;
				update_option( $default_locker_option_id, $optionValue );
			}
		} else {
			if ( empty ( $default_locker_option_val ) ) {
				update_option( $default_locker_option_id, $id );
			}
		}

		update_option( $default_locker_option_id, $id );

		// add meta
		foreach ( $post_meta as $post_meta_key => $post_meta_data ) {
			add_post_meta( $id, $post_meta_key, $post_meta_data );
		}

		return $id;

	}

	/**
	 * update admin menu
	 */
	public static function admin_menu() {
		global $menu;
		global $submenu;

		foreach( $menu as $index => $item ) {
			if ( isset( $item[2] ) && $item[2] === 'edit.php?post_type=tds_email' ) {
				$menu[$index][0] = 'Opt-In Builder';
				break;
			}
		}

	}

	/**
	 * adds `locked_only` filter to blocks params array ( filter to show exclusive posts only)
	 *
	 * hooked on 'td_composer_map_filter_array' in td-composer & 'td_cloud_library_loop_map_filter_array' filter in td-cloud-library
	 */
	public static function add_locked_posts_filter( $filters_array, $group ) {
		return array_merge(
			$filters_array,
			array(
				array(
					"param_name"  => "locked_only",
					"type"        => "checkbox",
					"value"       => '',
					"heading"     => "Show exclusive posts only",
					"description" => "",
					"holder"      => "div",
					"class"       => "",
					"info_img"    => "",
					'group'       => $group
				)
			)
		);
	}

	/**
	 * adds `locked_only` wp query args filter to blocks query ( filter to show exclusive posts only)
	 *
	 * hooked on 'td_data_source_blocks_query_args' in td-composer/legacy/common/wp_booster/td_data_source.php
	 */
	public static function add_locked_posts_filter_args( $td_query_args, $td_block_atts ) {

		// get block type
		$block_type = $td_block_atts['block_type'] ?? null;

		// the list of block types we target
		$block_types = array(
			'td_flex_block_1',
			'td_flex_block_2',
			'td_flex_block_3',
			'td_flex_block_4',
			'td_flex_block_5'
		);

		if ( $block_type && in_array( $block_type, $block_types ) /*&& !( tdc_state::is_live_editor_iframe() || tdc_state::is_live_editor_ajax() )*/ ) {

			//echo '<pre class="td-container">';
			//echo '$td_query_args: ' . PHP_EOL;
			//print_r($td_query_args);
			//echo '$td_block_atts: ' . PHP_EOL;
			//echo 'locked_only: ';
			//var_dump($td_block_atts['locked_only']);
			//echo '</pre>';

			// locked content
			$locked_only = $td_block_atts['locked_only'] ?? null;
			if ( $locked_only ) {
				$td_query_args['meta_key'] = 'tds_lock_content';
			}

		}

		return $td_query_args;
	}

    /**
     * adds exclusive label params array
     *
     * hooked on 'get_map_exclusive_label_array' in td-composer & td-cloud-library
     */
    public static function add_exclusive_label_settings( $label_array, $index, $sep_small, $group ) {

        if( $index != '' ) {
            $index = '_' . $index;
        }

        $sep_class = '';
        if ( $sep_small ) {
            $sep_class = 'tdc-separator-small';
        }

        return array_merge(
            $label_array,
            array(
                array(
                    "param_name" => "separator",
                    "type" => "text_separator",
                    'heading' => 'Exclusive label',
                    "value" => "",
                    "class" => $sep_class,
                    "group" => $group,
                ),
                array(
                    "param_name" => "excl_show" . $index,
                    "type" => "dropdown-responsive",
                    "value" => array(
                        'Show' => 'inline-block',
                        'Hide' => 'none',
                    ),
                    "heading" => 'Show label',
                    "description" => "",
                    "holder" => "div",
                    "class" => "tdc-dropdown-big",
                    "group" => $group,
                    "info_img" => "",
                ),
                array(
                    "param_name" => "separator",
                    "type" => "horizontal_separator",
                    "value" => "",
                    "class" => "tdc-separator-small",
                    "group" => $group,
                ),
                array(
                    "param_name" => "excl_txt" . $index,
                    "type" => "textfield",
                    "value" => '',
                    "heading" => 'Text',
                    "description" => "",
                    "holder" => "div",
                    "class" => "tdc-textfield-big",
                    "placeholder" => "EXCLUSIVE",
                    "group" => $group,
                    "info_img" => "",
                ),
                array(
                    "param_name" => "separator",
                    "type" => "horizontal_separator",
                    "value" => "",
                    "class" => "tdc-separator-small",
                    "group" => $group,
                ),
                array(
                    "param_name" => "excl_margin" . $index,
                    "type" => "textfield-responsive",
                    "value" => '',
                    "heading" => 'Spacing',
                    "description" => "",
                    "holder" => "div",
                    "class" => "tdc-textfield-big",
                    "placeholder" => "0 8px 0 0",
                    "group" => $group,
                    "info_img" => "",
                ),
                array(
                    "param_name" => "excl_padd" . $index,
                    "type" => "textfield-responsive",
                    "value" => '',
                    "heading" => 'Padding',
                    "description" => "",
                    "holder" => "div",
                    "class" => "tdc-textfield-big",
                    "placeholder" => "4px 8px 2px",
                    "group" => $group,
                    "info_img" => "",
                ),
                array(
                    "param_name" => "all_excl_border" . $index,
                    "type" => "textfield-responsive",
                    "value" => '',
                    "heading" => 'Border size',
                    "description" => "",
                    "holder" => "div",
                    "class" => "tdc-textfield-big",
                    "placeholder" => "0",
                    "group" => $group,
                    "info_img" => "",
                ),
                array(
                    "param_name"  => "all_excl_border_style" . $index,
                    "type"        => "dropdown-responsive",
                    "value"       => array(
                        'Solid'  => 'solid',
                        'Dotted' => 'dotted',
                        'Dashed' => 'dashed',
                    ),
                    "heading"     => 'Border style',
                    "description" => "",
                    "holder"      => "div",
                    "class"       => "tdc-dropdown-big",
                    "group"       => $group,
                    "info_img" => "",
                ),
                array(
                    "param_name" => "excl_radius" . $index,
                    "type" => "textfield-responsive",
                    "value" => '',
                    "heading" => 'Border radius',
                    "description" => "",
                    "holder" => "div",
                    "class" => "tdc-textfield-big",
                    "placeholder" => "0",
                    "group" => $group,
                    "info_img" => "",
                ),
                array(
                    "param_name" => "separator",
                    "type" => "text_separator",
                    'heading' => 'Style',
                    "value" => "",
                    "class" => "tdc-separator-small",
                    "group" => $group,
                ),
                array(
                    "type" => "colorpicker",
                    "holder" => "div",
                    "class" => "tdc-colorpicker-double-a",
                    "heading" => 'Text color',
                    "param_name" => "excl_color" . $index,
                    "value" => '',
                    "description" => '',
                    "group" => $group,
                ),
                array(
                    "type" => "colorpicker",
                    "holder" => "div",
                    "class" => "tdc-colorpicker-double-b",
                    "heading" => 'Text hover color',
                    "param_name" => "excl_color_h" . $index,
                    "value" => '',
                    "description" => '',
                    "group" => $group,
                ),
                array(
                    "type" => "colorpicker",
                    "holder" => "div",
                    "class" => "tdc-colorpicker-double-a",
                    "heading" => 'Background color',
                    "param_name" => "excl_bg" . $index,
                    "value" => '',
                    "description" => '',
                    "group" => $group,
                ),
                array(
                    "type" => "colorpicker",
                    "holder" => "div",
                    "class" => "tdc-colorpicker-double-b",
                    "heading" => 'Background hover color',
                    "param_name" => "excl_bg_h" . $index,
                    "value" => '',
                    "description" => '',
                    "group" => $group,
                ),
                array(
                    "type" => "colorpicker",
                    "holder" => "div",
                    "class" => "tdc-colorpicker-double-a",
                    "heading" => 'Border color',
                    "param_name" => "all_excl_border_color" . $index,
                    "value" => '',
                    "description" => '',
                    "group" => $group,
                ),
                array(
                    "type" => "colorpicker",
                    "holder" => "div",
                    "class" => "tdc-colorpicker-double-b",
                    "heading" => 'Border hover color',
                    "param_name" => "excl_border_color_h" . $index,
                    "value" => '',
                    "description" => '',
                    "group" => $group,
                ),
                array(
                    "param_name" => "separator",
                    "type" => "horizontal_separator",
                    "value" => "",
                    "class" => "tdc-separator-small",
                    "group" => $group,
                ),
            ),
            td_config_helper::get_map_block_font_array( 'f_excl' . $index, true, 'Label text', $group )
        );

    }

    /**
     * adds 'exclusive' class to modules
     *
     * hooked on 'render' in td-composer/legacy/Newspaper/modules
     */
	public static function add_exclusive_class_on_modules( $additional_classes, $post ) {

	    $locked_content_meta = get_post_meta($post->ID, 'tds_lock_content');
        if( $locked_content_meta ) {
            $additional_classes[] = 'td-module-exclusive';
        }

	    return $additional_classes;

    }

    /**
     * adds 'exclusive' class to modules
     *
     * hooked on 'render' in td-cloud-library/modules
     */
    public static function add_exclusive_class_on_cloud_modules( $additional_classes, $post ) {

        $locked_content_meta = get_post_meta($post['post_id'], 'tds_lock_content');
        if( $locked_content_meta ) {
            $additional_classes[] = 'td-module-exclusive';
        }

        return $additional_classes;

    }

	/**
	 * callback hooked to theme's post theme settings metabox setup options to add the save_filter callback option
	 *
	 * @param $mb_setup_options
	 *
	 * @return mixed
	 */
	public static function add_mb_setup_options( $mb_setup_options ) {
		$mb_setup_options['save_filter'] = array( __CLASS__, 'td_post_theme_settings_mb_save_filter' );
		return $mb_setup_options;
	}

	/**
	 * callback for td_post_theme_settings metabox > 'save_filter' option
	 *
	 * on post save.. this callback creates an individual tds lock content meta on post that will be used to filter posts via content lock
	 *
	 * @param $metabox_data_array
	 * @param $post_id
	 *
	 * @return mixed
	 */
	public static function td_post_theme_settings_mb_save_filter( $metabox_data_array, $post_id ) {

		// check for tds_lock_content key in meta box data..
		if ( array_key_exists( 'tds_lock_content', $metabox_data_array ) ) {
			update_post_meta( $post_id, 'tds_lock_content', $metabox_data_array['tds_lock_content'] );
		} else {
			delete_post_meta( $post_id, 'tds_lock_content' );
		}

		//print_r($metabox_data_array);
		//print_r($post_id);
		//exit; // exit here only to show you the output when saving

		return $metabox_data_array;
	}

}