<?php


class tds_config {

	static $js_files_for_front = array (
		'tdsLeads' => '/assets/js/frontend/tdsLeads.js', // add leads js
	);

	static function on_tdc_loaded() {

		td_api_block::add('tds_leads',
			array(
				'map_in_td_composer' => true,
				"name" => 'Leads',
				"base" => "tds_leads",
				'tdc_category' => 'Blocks',
				'file' => TDS_PATH . '/includes/shortcodes/tds_leads.php',
				'tdc_style_params' => array(
				    'title_text',
                    'title_tag',
                    'msg_composer',
                    'input_placeholder',
                    'btn_text',
                    'pp_msg',
                    'el_class'
                ),
				'tdc_start_values' => base64_encode(
					json_encode(
						array(
							'title_text' => 'Subscribe',
							'input_placeholder' => 'Your email address',
                            'btn_horiz_align' => 'content-horiz-center',
                            'pp_checkbox' => 'yes',
                            'pp_msg' => 'SSd2ZSUyMHJlYWQlMjBhbmQlMjBhY2NlcHQlMjB0aGUlMjAlM0NhJTIwaHJlZiUzRCUyMiUyMyUyMiUzRVByaXZhY3klMjBQb2xpY3klM0MlMkZhJTNFLg=='
						)
					)
				),
				"params" => array_merge(
					array(
                        array(
                            "param_name" => "list",
                            "type" => "dropdown",
                            "value" => self::get_lists(),
                            "heading" => 'Mailing list',
                            "description" => "The list in which you want to store the received email addresses.",
                            "holder" => "div",
                            "class" => "tdc-dropdown-big"
                        ),
                        array(
                            "param_name" => "successful_submit_rdr_url",
                            "type" => "textfield",
                            "value" => "",
                            "heading" => 'Redirect url',
                            "description" => "Optional - a custom url for when the form is successfully submitted",
                            "holder" => "div",
                            "class" => "tdc-textfield-extrabig",
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "horizontal_separator",
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group" => '',
                        ),
						array(
							'param_name' => 'title_text',
							'type' => 'textfield',
							'value' => '',
							'heading' => 'Title text',
							'description' => '',
							'class' => 'tdc-textfield-extrabig',
						),
                        array(
                            "param_name" => "title_tag",
                            "type" => "dropdown",
                            "value" => array(
                                'Default - H3' => '',
                                'H1' => 'h1',
                                'H2' => 'h2',
                                'H4' => 'h4',
                                'Div' => 'div'
                            ),
                            "heading" => 'Title tag (SEO)',
                            "description" => "",
                            "holder" => "div",
                            "class" => "tdc-dropdown-big",
                            "info_img" => "https://cloud.tagdiv.com/help/title_seo.png",
                        ),
                        array(
                            "param_name" => "title_space",
                            "type" => "textfield-responsive",
                            "value" => '',
                            "heading" => 'Title space',
                            "description" => "",
                            "placeholder" => "20",
                            "holder" => "div",
                            "class" => "tdc-textfield-small"
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "text_separator",
                            "heading" => 'Message',
                            "value" => "",
                            "class" => "",
                        ),
                        array(
                            "param_name" => "msg_composer",
                            "type" => "dropdown",
                            "value" => array(
                                'No message' => '',
                                'Success message' => 'success',
                                'Error message' => 'error',
                            ),
                            "heading" => 'Show in composer',
                            "description" => "",
                            "holder" => "div",
                            "class" => "tdc-dropdown-big",
                            "info_img" => "",
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "horizontal_separator",
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group" => '',
                        ),
                        array(
                            "param_name" => "msg_pos",
                            "type" => "dropdown",
                            "value" => array(
                                'Below title' => 'title',
                                'Below form' => 'form',
                            ),
                            "heading" => 'Position',
                            "description" => "",
                            "holder" => "div",
                            "class" => "tdc-dropdown-big",
                            "info_img" => "",
                        ),
                        array(
                            "param_name" => "msg_space",
                            "type" => "textfield-responsive",
                            "value" => '',
                            "heading" => 'Space',
                            "description" => "",
                            "placeholder" => "0 0 16px",
                            "holder" => "div",
                            "class" => "tdc-textfield-big"
                        ),
                        array(
                            "param_name" => "msg_padd",
                            "type" => "textfield-responsive",
                            "value" => '',
                            "heading" => 'Padding',
                            "description" => "",
                            "placeholder" => "8px 12px",
                            "holder" => "div",
                            "class" => "tdc-textfield-big"
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "text_separator",
                            "heading" => 'Success messages',
                            "value" => "",
                            "class" => "tdc-separator-small",
                        ),
                        array(
                            "param_name" => "all_msg_succ_border",
                            "type" => "textfield-responsive",
                            "value" => '',
                            "heading" => 'Border size',
                            "description" => "",
                            "placeholder" => "0",
                            "holder" => "div",
                            "class" => "tdc-textfield-big"
                        ),
                        array(
                            "param_name" => "all_msg_succ_border_style",
                            "type" => "dropdown-responsive",
                            "value" => array(
                                'Solid' => 'solid',
                                'Dotted' => 'dotted',
                                'Dashed' => 'dashed',
                            ),
                            "heading" => 'Border style',
                            "description" => "",
                            "holder" => "div",
                            "class" => "tdc-dropdown-big",
                            "info_img" => "",
                        ),
                        array(
                            "param_name" => "msg_succ_radius",
                            "type" => "textfield-responsive",
                            "value" => '',
                            "heading" => 'Border radius',
                            "description" => "",
                            "placeholder" => "3",
                            "holder" => "div",
                            "class" => "tdc-textfield-big"
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "text_separator",
                            "heading" => 'Error messages',
                            "value" => "",
                            "class" => "tdc-separator-small",
                        ),
                        array(
                            "param_name" => "all_msg_err_border",
                            "type" => "textfield-responsive",
                            "value" => '',
                            "heading" => 'Border size',
                            "description" => "",
                            "placeholder" => "0",
                            "holder" => "div",
                            "class" => "tdc-textfield-big"
                        ),
                        array(
                            "param_name" => "all_msg_err_border_style",
                            "type" => "dropdown-responsive",
                            "value" => array(
                                'Solid' => 'solid',
                                'Dotted' => 'dotted',
                                'Dashed' => 'dashed',
                            ),
                            "heading" => 'Border style',
                            "description" => "",
                            "holder" => "div",
                            "class" => "tdc-dropdown-big",
                            "info_img" => "",
                        ),
                        array(
                            "param_name" => "msg_err_radius",
                            "type" => "textfield-responsive",
                            "value" => '',
                            "heading" => 'Border radius',
                            "description" => "",
                            "placeholder" => "3",
                            "holder" => "div",
                            "class" => "tdc-textfield-big"
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "text_separator",
                            "heading" => 'Input & Button',
                            "value" => "",
                            "class" => "",
                        ),
                        array(
                            "param_name" => "display",
                            "type" => "dropdown-responsive",
                            "value" => array(
                                'Columns' => 'row',
                                'Row' => 'column',
                            ),
                            "heading" => 'Display',
                            "description" => "",
                            "holder" => "div",
                            "class" => "tdc-dropdown-big",
                            "info_img" => "",
                        ),
                        array(
                            "param_name" => "gap",
                            "type" => "textfield-responsive",
                            "value" => '',
                            "heading" => 'Gap',
                            "description" => "",
                            "placeholder" => "0",
                            "holder" => "div",
                            "class" => "tdc-textfield-small"
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "text_separator",
                            "heading" => 'Input',
                            "value" => "",
                            "class" => "tdc-separator-small",
                        ),
						array(
							"param_name" => "input_placeholder",
							"type" => "textfield",
							"value" => '',
							"heading" => 'Placeholder text',
							"description" => "",
							"holder" => "div",
							"class" => "tdc-textfield-big"
						),
                        array(
                            "param_name" => "separator",
                            "type" => "horizontal_separator",
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group" => '',
                        ),
                        array(
                            "param_name" => "input_padd",
                            "type" => "textfield-responsive",
                            "value" => '',
                            "heading" => 'Padding',
                            "description" => "",
                            "placeholder" => "12px 15px",
                            "holder" => "div",
                            "class" => "tdc-textfield-big"
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "horizontal_separator",
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group" => '',
                        ),
                        array(
                            "param_name" => "input_border",
                            "type" => "textfield-responsive",
                            "value" => '',
                            "heading" => 'Border size',
                            "description" => "",
                            "placeholder" => "1px 0 1px 1px",
                            "holder" => "div",
                            "class" => "tdc-textfield-big"
                        ),
                        array(
                            "param_name" => "input_border_style",
                            "type" => "dropdown-responsive",
                            "value" => array(
                                'Solid' => 'solid',
                                'Dotted' => 'dotted',
                                'Dashed' => 'dashed',
                            ),
                            "heading" => 'Border style',
                            "description" => "",
                            "holder" => "div",
                            "class" => "tdc-dropdown-big",
                            "info_img" => "",
                        ),
                        array(
                            "param_name" => "input_radius",
                            "type" => "textfield-responsive",
                            "value" => '',
                            "heading" => 'Border radius',
                            "description" => "",
                            "placeholder" => "0",
                            "holder" => "div",
                            "class" => "tdc-textfield-big"
                        ),
						array(
							"param_name" => "separator",
							"type" => "text_separator",
							"heading" => 'Button',
							"value" => "",
							"class" => "tdc-separator-small",
						),
						array(
							"param_name" => "btn_text",
							"type" => "textfield",
							"value" => '',
							"heading" => 'Button text',
							"description" => "",
							"placeholder" => "Subscribe",
							"holder" => "div",
							"class" => "tdc-textfield-big"
						),
                        array(
                            "param_name" => "separator",
                            "type" => "horizontal_separator",
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group" => '',
                        ),
                        array(
                            'param_name' => 'btn_tdicon',
                            'type' => 'icon',
                            'heading' => 'Icon',
                            'class' => 'tdc-textfield-small',
                            'value' => '',
                            "group"       => '',
                            "info_img" => "",
                        ),
                        array(
                            "param_name" => "btn_icon_pos",
                            "type" => "dropdown",
                            "value" => array(
                                'After text' => 'after',
                                'Before text' => 'before',
                            ),
                            "heading" => 'Icon position',
                            "description" => "",
                            "holder" => "div",
                            "class" => "tdc-dropdown-big",
                            "info_img" => "",
                        ),
                        array(
                            "param_name" => "btn_icon_size",
                            "type" => "textfield-responsive",
                            "value" => '',
                            "heading" => 'Size',
                            "description" => "",
                            "placeholder" => "16",
                            "holder" => "div",
                            "class" => "tdc-textfield-small"
                        ),
                        array(
                            "param_name" => "btn_icon_space",
                            "type" => "textfield-responsive",
                            "value" => '',
                            "heading" => 'Space',
                            "description" => "",
                            "placeholder" => "6",
                            "holder" => "div",
                            "class" => "tdc-textfield-small"
                        ),
                        array(
                            'param_name' => 'btn_icon_align',
                            'type' => 'range-responsive',
                            'value' => '0',
                            'heading' => 'Icon vertical alignment',
                            'description' => '',
                            'class' => 'tdc-textfield-small',
                            'range_min' => '-10',
                            'range_max' => '10',
                            'range_step' => '1',
                            "info_img" => "",
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "horizontal_separator",
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group" => '',
                        ),
                        array(
                            "param_name" => "btn_padd",
                            "type" => "textfield-responsive",
                            "value" => '',
                            "heading" => 'Padding',
                            "description" => "",
                            "placeholder" => "15",
                            "holder" => "div",
                            "class" => "tdc-textfield-big"
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "horizontal_separator",
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group" => '',
                        ),
                        array(
                            "param_name" => "all_btn_border",
                            "type" => "textfield-responsive",
                            "value" => '',
                            "heading" => 'Border size',
                            "description" => "",
                            "placeholder" => "0",
                            "holder" => "div",
                            "class" => "tdc-textfield-big"
                        ),
                        array(
                            "param_name" => "all_btn_border_style",
                            "type" => "dropdown-responsive",
                            "value" => array(
                                'Solid' => 'solid',
                                'Dotted' => 'dotted',
                                'Dashed' => 'dashed',
                            ),
                            "heading" => 'Border style',
                            "description" => "",
                            "holder" => "div",
                            "class" => "tdc-dropdown-big",
                            "info_img" => "",
                        ),
                        array(
                            "param_name" => "btn_radius",
                            "type" => "textfield-responsive",
                            "value" => '',
                            "heading" => 'Border radius',
                            "description" => "",
                            "placeholder" => "0",
                            "holder" => "div",
                            "class" => "tdc-textfield-big"
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "horizontal_separator",
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group" => '',
                        ),
                        array(
                            "param_name" => "btn_horiz_align",
                            "type" => "dropdown-responsive",
                            "value" => array(
                                'Left' => 'content-horiz-left',
                                'Center' => 'content-horiz-center',
                                'Right' => 'content-horiz-right'
                            ),
                            "heading" => 'Horizontal align',
                            "description" => "",
                            "holder" => "div",
                            'tdc_dropdown_images' => true,
                            "class" => "tdc-visual-selector tdc-add-class",
                            "group"       => "",
                            "info_img" => ""
                        ),
						array(
							"param_name" => "separator",
							"type" => "text_separator",
							"heading" => 'Privacy Policy',
							"value" => "",
							"class" => "",
						),
                        array(
                            "param_name" => "pp_space",
                            "type" => "textfield-responsive",
                            "value" => '',
                            "heading" => 'Top space',
                            "description" => "",
                            "placeholder" => "16",
                            "holder" => "div",
                            "class" => "tdc-textfield-small"
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "text_separator",
                            "heading" => 'Checkbox',
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group" => "",
                        ),
                        array(
                            "param_name" => "pp_checkbox",
                            "type" => "checkbox",
                            "value" => '',
                            "heading" => 'Enable checkbox',
                            "description" => "Enable privacy policy checkbox",
                            "holder" => "div",
                            "class" => ""
                        ),
                        array(
                            'param_name' => 'pp_check_size',
                            'type' => 'range-responsive',
                            'value' => '16',
                            'heading' => 'Size',
                            'description' => '',
                            'class' => 'tdc-textfield-small',
                            'range_min' => '12',
                            'range_max' => '30',
                            'range_step' => '1',
                            "info_img" => "",
                        ),
                        array(
                            "param_name" => "pp_check_space",
                            "type" => "textfield-responsive",
                            "value" => '',
                            "heading" => 'Space',
                            "description" => "",
                            "placeholder" => "8",
                            "holder" => "div",
                            "class" => "tdc-textfield-small"
                        ),
                        array(
                            "param_name" => "pp_check_radius",
                            "type" => "textfield-responsive",
                            "value" => '',
                            "heading" => 'Border radius',
                            "description" => "",
                            "placeholder" => "0",
                            "holder" => "div",
                            "class" => "tdc-textfield-small"
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "text_separator",
                            "heading" => 'Text',
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group" => "",
                        ),
                        array(
                            'param_name' => 'pp_msg',
                            'type' => 'textarea_raw_html',
                            'value' => '',
                            'heading' => 'Privacy policy text',
                            'description' => '',
                            'class' => 'tdc-textarea-extrasmall',
                        ),
                        array(
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "",
                            "heading" => 'Title color',
                            "param_name" => "title_color",
                            "value" => '',
                            "description" => '',
                            "group" => "Style",
                            "info_img" => "",
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "horizontal_separator",
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group" => 'Style',
                        ),
                    ),
                    td_config_helper::get_map_block_font_array( 'f_title', true, 'Title text', 'Style' ),
                    array(
                        array(
                            "param_name" => "separator",
                            "type" => "text_separator",
                            "heading" => 'Message',
                            "value" => "",
                            "class" => "",
                            "group" => "Style",
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "text_separator",
                            "heading" => 'Success messages',
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group" => "Style",
                        ),
                        array(
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "",
                            "heading" => 'Text color',
                            "param_name" => "msg_succ_color",
                            "value" => '',
                            "description" => '',
                            "group" => "Style",
                            "info_img" => "",
                        ),
                        array(
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "",
                            "heading" => 'Background color',
                            "param_name" => "msg_succ_bg",
                            "value" => '',
                            "description" => '',
                            "group" => "Style",
                            "info_img" => "",
                        ),
                        array(
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "",
                            "heading" => 'Border color',
                            "param_name" => "all_msg_succ_border_color",
                            "value" => '',
                            "description" => '',
                            "group" => "Style",
                            "info_img" => "",
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "text_separator",
                            "heading" => 'Error messages',
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group" => "Style",
                        ),
                        array(
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "",
                            "heading" => 'Text color',
                            "param_name" => "msg_error_color",
                            "value" => '',
                            "description" => '',
                            "group" => "Style",
                            "info_img" => "",
                        ),
                        array(
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "",
                            "heading" => 'Background color',
                            "param_name" => "msg_err_bg",
                            "value" => '',
                            "description" => '',
                            "group" => "Style",
                            "info_img" => "",
                        ),
                        array(
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "",
                            "heading" => 'Border color',
                            "param_name" => "all_msg_err_border_color",
                            "value" => '',
                            "description" => '',
                            "group" => "Style",
                            "info_img" => "",
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "horizontal_separator",
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group" => 'Style',
                        ),
                    ),
                    td_config_helper::get_map_block_font_array( 'f_msg', true, 'Message text', 'Style' ),
                    array(
                        array(
                            "param_name" => "separator",
                            "type" => "text_separator",
                            "heading" => 'Input',
                            "value" => "",
                            "class" => "",
                            "group" => "Style",
                        ),
                        array(
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "",
                            "heading" => 'Text color',
                            "param_name" => "input_color",
                            "value" => '',
                            "description" => '',
                            "group" => "Style",
                            "info_img" => "",
                        ),
                        array(
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "",
                            "heading" => 'Placeholder text color',
                            "param_name" => "input_place_color",
                            "value" => '',
                            "description" => '',
                            "group" => "Style",
                            "info_img" => "",
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "horizontal_separator",
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group" => 'Style',
                        ),
                        array(
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "td-colorpicker-double-a",
                            "heading" => 'Background color',
                            "param_name" => "input_bg",
                            "value" => '',
                            "description" => '',
                            "group" => "Style",
                            "info_img" => "",
                        ),
                        array(
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "td-colorpicker-double-b",
                            "heading" => 'Background focus color',
                            "param_name" => "input_bg_f",
                            "value" => '',
                            "description" => '',
                            "group" => "Style",
                            "info_img" => "",
                        ),
                        array(
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "td-colorpicker-double-a",
                            "heading" => 'Border color',
                            "param_name" => "input_border_color",
                            "value" => '',
                            "description" => '',
                            "group" => "Style",
                            "info_img" => "",
                        ),
                        array(
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "td-colorpicker-double-b",
                            "heading" => 'Border focus color',
                            "param_name" => "input_border_color_f",
                            "value" => '',
                            "description" => '',
                            "group" => "Style",
                            "info_img" => "",
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "horizontal_separator",
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group" => 'Style',
                        ),
                    ),
                    td_config_helper::get_map_block_font_array( 'f_input', true, 'Input text', 'Style' ),
                    array(
                        array(
                            "param_name" => "separator",
                            "type" => "text_separator",
                            "heading" => 'Button',
                            "value" => "",
                            "class" => "",
                            "group" => "Style",
                        ),
                        array(
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "td-colorpicker-double-a",
                            "heading" => 'Text color',
                            "param_name" => "btn_color",
                            "value" => '',
                            "description" => '',
                            "group" => "Style",
                            "info_img" => "",
                        ),
                        array(
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "td-colorpicker-double-b",
                            "heading" => 'Text hover color',
                            "param_name" => "btn_color_h",
                            "value" => '',
                            "description" => '',
                            "group" => "Style",
                            "info_img" => "",
                        ),
                        array(
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "td-colorpicker-double-a",
                            "heading" => 'Icon color',
                            "param_name" => "btn_icon_color",
                            "value" => '',
                            "description" => '',
                            "group" => "Style",
                            "info_img" => "",
                        ),
                        array(
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "td-colorpicker-double-b",
                            "heading" => 'Icon hover color',
                            "param_name" => "btn_icon_color_h",
                            "value" => '',
                            "description" => '',
                            "group" => "Style",
                            "info_img" => "",
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "horizontal_separator",
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group" => 'Style',
                        ),
                        array(
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "td-colorpicker-double-a",
                            "heading" => 'Background color',
                            "param_name" => "btn_bg",
                            "value" => '',
                            "description" => '',
                            "group" => "Style",
                            "info_img" => "",
                        ),
                        array(
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "td-colorpicker-double-b",
                            "heading" => 'Background hover color',
                            "param_name" => "btn_bg_h",
                            "value" => '',
                            "description" => '',
                            "group" => "Style",
                            "info_img" => "",
                        ),
                        array(
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "td-colorpicker-double-a",
                            "heading" => 'Border color',
                            "param_name" => "all_btn_border_color",
                            "value" => '',
                            "description" => '',
                            "group" => "Style",
                            "info_img" => "",
                        ),
                        array(
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "td-colorpicker-double-b",
                            "heading" => 'Border hover color',
                            "param_name" => "btn_border_color_h",
                            "value" => '',
                            "description" => '',
                            "group" => "Style",
                            "info_img" => "",
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "horizontal_separator",
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group" => 'Style',
                        ),
                    ),
                    td_config_helper::get_map_block_font_array( 'f_btn', true, 'Button text', 'Style' ),
                    array(
                        array(
                            "param_name" => "separator",
                            "type" => "text_separator",
                            "heading" => 'Privacy policy',
                            "value" => "",
                            "class" => "",
                            "group" => "Style",
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "text_separator",
                            "heading" => 'Checkbox',
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group" => "Style",
                        ),
                        array(
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "",
                            "heading" => 'Checked square color',
                            "param_name" => "pp_check_square",
                            "value" => '',
                            "description" => '',
                            "group" => "Style",
                            "info_img" => "",
                        ),
                        array(
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "td-colorpicker-double-a",
                            "heading" => 'Background color',
                            "param_name" => "pp_check_bg",
                            "value" => '',
                            "description" => '',
                            "group" => "Style",
                            "info_img" => "",
                        ),
                        array(
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "td-colorpicker-double-b",
                            "heading" => 'Background checked color',
                            "param_name" => "pp_check_bg_c",
                            "value" => '',
                            "description" => '',
                            "group" => "Style",
                            "info_img" => "",
                        ),
                        array(
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "td-colorpicker-double-a",
                            "heading" => 'Border color',
                            "param_name" => "pp_check_border_color",
                            "value" => '',
                            "description" => '',
                            "group" => "Style",
                            "info_img" => "",
                        ),
                        array(
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "td-colorpicker-double-b",
                            "heading" => 'Border checked color',
                            "param_name" => "pp_check_border_color_c",
                            "value" => '',
                            "description" => '',
                            "group" => "Style",
                            "info_img" => "",
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "text_separator",
                            "heading" => 'Text',
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group" => "Style",
                        ),
                        array(
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "",
                            "heading" => 'Text color',
                            "param_name" => "pp_check_color",
                            "value" => '',
                            "description" => '',
                            "group" => "Style",
                            "info_img" => "",
                        ),
                        array(
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "td-colorpicker-double-a",
                            "heading" => 'Links color',
                            "param_name" => "pp_check_color_a",
                            "value" => '',
                            "description" => '',
                            "group" => "Style",
                            "info_img" => "",
                        ),
                        array(
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "td-colorpicker-double-b",
                            "heading" => 'Links hover color',
                            "param_name" => "pp_check_color_a_h",
                            "value" => '',
                            "description" => '',
                            "group" => "Style",
                            "info_img" => "",
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "horizontal_separator",
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group" => 'Style',
                        ),
                    ),
                    td_config_helper::get_map_block_font_array( 'f_pp', true, 'Privacy policy text', 'Style' ),
					self::get_block_style()
				)
			)
		);

		td_api_block::add( 'tds_locker',
			array(
				"map_in_td_composer" => false,
				"name" => 'TDS Locker',
				"base" => 'tds_locker',
				"file" => TDS_PATH . '/includes/shortcodes/tds_locker.php',
				"params" => array()
			)

		);

	}

	static function get_block_style() {
		return array(
			array(
				"param_name" => "separator",
				"type" => "horizontal_separator",
				"value" => "",
				"class" => ""
			),
			array(
				'param_name' => 'el_class',
				'type' => 'textfield',
				'value' => '',
				'heading' => 'Extra class',
				'description' => 'Style particular content element differently - add a class name and refer to it in custom CSS',
				'class' => 'tdc-textfield-extrabig',
			),
			array(
				'param_name' => 'tdc_css',
				'value' => '',
				'type' => 'tdc_css_editor',
				'heading' => '',
				'group' => 'Design options',
			)
		);
	}

	static function get_lists() {

		// the lists tax is not registered at this point to get lists so we need to register it..
		td_subscription::register_taxonomy();

		// default list
		//$default_list_id = (int) get_option( 'default_term_tds_list' );

		// get tds list taxonomies
		$tds_lists = get_terms( array(
			'taxonomy' => 'tds_list',
			'hide_empty' => false,
			//'exclude' => array( $default_list_id ), // exclude default
		) );

		$lists = array(
			'Default List' => ''
		);

		if ( !empty( $tds_lists ) && is_array( $tds_lists ) ) {
			foreach ( $tds_lists as $list ) {
				if( $list->name === 'Default List' )
					continue;
				$lists[$list->name] = $list->term_id;
			}
		}

		return $lists;
	}

}