<?php
/**
 * tds form submission class
 *
 */

defined( 'ABSPATH' ) || exit;

class tds_form_submission {

	private static $errors = array();

	private static $result = array();

	public static function init() {
		add_action( 'init', array( __CLASS__, 'process_submission' ) );
	}

	public static function process_submission() {

		// check email
		if ( isset( $_POST['email'] ) ) {
			$email = isset( $_POST['email'] ) ? sanitize_email( wp_unslash( $_POST['email'] ) ) : '';
			$list = isset( $_POST['list'] ) ? (int) $_POST['list'] : '';
			$rdr_url = $_POST['rdr_url'] ?? '';

			if ( is_email( $email ) ) {

				$new_lead_data = array(
					'tds_email' => $email,
					'tds_list_id' => $list
				);

				// store(add) email
				$tds_leads_api_response = tds_leads_api::add( $new_lead_data );

				// error
				if ( self::is_api_error( $tds_leads_api_response ) ) {

					// set errors response
					self::$errors[$tds_leads_api_response['id']] = $tds_leads_api_response['message'];

				// success
				} else {

					// set results resp
					self::$result = $tds_leads_api_response;
					self::$result['new_lead_data'] = $new_lead_data;

					// set cookies
					self::set_cookies();

					// maybe redirect
					if ( !empty( $rdr_url ) ) {
						wp_redirect( $rdr_url );
						exit();
					}

				}

			} else {
				self::$errors['email_not_valid'] = 'Please fill in a valid email.';
			}

		} else {
			self::$errors['email_not_set'] = 'Please fill in an email address.';
		}

	}

	public static function is_api_error($response) {
		return isset( $response['type'] ) && $response['type'] === 'error';
	}

	public static function has_errors() {
		if ( !empty( self::$errors ) ) {
			return true;
		}
		return false;
	}

	public static function get_errors() {
		return self::$errors;
	}

	public static function get_result() {
		return self::$result;
	}

	public static function set_cookies() {

		// do not set the cookies if the headers have been sent for some reasons ..otherwise a user can see warnings
		if ( headers_sent() )
			return;

		$new_cookie_val = array();
		$result = self::get_result();
		$new_lead_list_id = $result['new_lead_data']['tds_list_id'];

		if ( !isset( $_COOKIE['tds_leads'] ) ) {
			$new_cookie_val[] = $new_lead_list_id;
		} else {
			//$old_cookie_val = maybe_unserialize( $_COOKIE['tds_leads'] );
			$old_cookie_val = $_COOKIE['tds_leads'];
			$new_cookie_val = array_merge( array( $new_lead_list_id ), explode( ',', $old_cookie_val ) );
		}

		if( !empty( $new_cookie_val ) ) {
			setcookie(
				'tds_leads',
				//serialize( $new_cookie_val ),
				implode( ',', $new_cookie_val ),
				time() + 3600 * 24 * 5000,
				COOKIEPATH,
				COOKIE_DOMAIN
			);
		}

	}

}

tds_form_submission::init();