<?php


class tds_util {

	/**
	 * determines if an email(cpt) exists in a list(custom tax) based on email(post title)
	 *
	 * @param string $email - tds email (post title)
	 * @param int $list - tds list (taxonomy) id
	 *
	 * @return int post ID if post exists, 0 otherwise
	 *
	 */
	static function exists( string $email, int $list ): int {
		global $wpdb;

		$post_title = wp_unslash( sanitize_post_field( 'post_title', $email, 0, 'db' ) );
		$list_id = wp_unslash( sanitize_term_field( 'term_id', $list, $list, 'tds_list', 'db' ) );

		$join = " INNER JOIN $wpdb->term_relationships ON ($wpdb->posts.ID = $wpdb->term_relationships.object_id)";
		$where = " WHERE 1=1";

		$query = "SELECT ID FROM $wpdb->posts";
		$query .= $join;
		$query .= $where;

		$args = array();

		$query .= " AND post_title = %s";
		$args[] = $post_title;

		$query .= " AND post_type = 'tds_email'";

		$query .= " AND $wpdb->term_relationships.term_taxonomy_id = %d";
		$args[] = $list_id;

		return (int) $wpdb->get_var( $wpdb->prepare( $query, $args ) );

	}

}