<?php
/**
 *  @copyright 2017  WPVKP  https://wpvkp.com
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */
defined('ABSPATH') || die('No direct script access allowed!');

class Ultimateoptimizer_PurgeCacheTime {
    protected $timettl = false;
    protected $normalcache = 0;
    protected $varnishcache = 0;
    public function __construct($settings = null)
    {
        $this->timettl = $settings['ultimateoptimizer-ttl'];

        $this->normalcache = (int)$settings['ultimateoptimizer-active'];

        $this->varnishcache = (int)$settings['ultimateoptimizer-varnish-purge'];

        add_action( 'ultimateoptimizer_purge_cache', array( $this, 'schedule_varnish' ) );
        add_action( 'init', array( $this, 'schedule_events' ) );
        add_filter( 'cron_schedules', array( $this, 'filter_cron_schedules' ) );

    }
    //     * Unschedule events
    public function unschedule_events() {
        $timestamp = wp_next_scheduled( 'ultimateoptimizer_purge_cache' );

        wp_unschedule_event( $timestamp, 'ultimateoptimizer_purge_cache' );
    }
    //       set up schedule_events
    public function schedule_events() {

        $timestamp = wp_next_scheduled( 'ultimateoptimizer_purge_cache' );

        // Expire cache never
        if ( isset( $this->timettl ) && (int)$this->timettl === 0 ) {
            wp_unschedule_event( $timestamp, 'ultimateoptimizer_purge_cache' );
            return;
        }

        if ( ! $timestamp ) {
            wp_schedule_event( time(), 'ultimateoptimizer_varnish_time', 'ultimateoptimizer_purge_cache' );
        }
    }

    /**
     * Add custom cron schedule
     */
    public function filter_cron_schedules( $schedules ) {
        if ( !empty( $this->timettl ) && is_numeric($this->timettl) && (int)$this->timettl > 0 ) {
            $interval = $this->timettl * 60;
        } else {
            $interval = '86400'; // One day
        }

        $schedules['ultimateoptimizer_varnish_time'] = array(
            'interval' => apply_filters( 'ultimateoptimizer_varnish_purge_interval', $interval ),
            'display'  => esc_html__( 'WPVKP Varnish Purge Interval', 'ultimateoptimizer' ),
        );

        return $schedules;
    }

    //execute purge varnish after time life
    public function schedule_varnish(){
        // Purge varnish cache
        if($this->varnishcache){
            do_action('ultimateoptimizer_clear_varnish');
        }

        // Purge normal cache
        if($this->normalcache){
            Ultimateoptimizer_PurgeCache::ultimateoptimizer_cache_flush();
	        Ultimateoptimizer_MinificationCache::clear_minification();
        }

    }

    public static function factory() {
        static $instance;
        if ( ! $instance ) {
            $instance = new self();
        }
        return $instance;
    }
}

$basic = get_option('ultimateoptimizer_basic_settings');
$varnish = get_option('ultimateoptimizer_varnish_cache');
//Enabled auto purge the varnish caching by time life
$params = array(
    'ultimateoptimizer-active' => (isset($basic['ultimateoptimizer-active'])?(int)$basic['ultimateoptimizer-active']:0),
    'ultimateoptimizer-ttl' => (isset($basic['ultimateoptimizer-ttl'])?(int)$basic['ultimateoptimizer-ttl']:0),
    'ultimateoptimizer-varnish-purge' => (isset($varnish['auto-purge-varnish'])?(int)$varnish['auto-purge-varnish']:0),
);

if($params['ultimateoptimizer-active'] || $params['ultimateoptimizer-varnish-purge']){
    $purgeTime = new Ultimateoptimizer_PurgeCacheTime($params);
}

