<?php
/**
 *  @copyright 2017  WPVKP  https://wpvkp.com
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */
defined('ABSPATH') || die('No direct script access allowed!');

// Load the queries from speed_must tab.
$query_conf = get_option('ultimateoptimizer_must_settings');


// Remove query strings.
if(!empty($query_conf['ultimateoptimizer-remove-query-strings']) && !isset($_GET['et_fb'])) {
    function ultimateoptimizer_remove_query( $src ) {
        // Remove query strings from static resources also jetpack query.
        if ( strpos( $src, '?ver=' ) || strpos( $src, '&ver=' ) || strpos( $src, '&v=' ) || strpos( $src, '?v=' ) || strpos( $src, '?w=') ) {
            $src = remove_query_arg( array( 'ver', 'v', 'w' ), $src );
        }
        return $src;
    }
    if( is_admin() ) {}
    else{
        add_filter( 'script_loader_src', 'ultimateoptimizer_remove_query', 15, 1 );
        add_filter( 'style_loader_src', 'ultimateoptimizer_remove_query', 15, 1 );
    }
}



// Remove wp-embed.js
if(!empty($query_conf['ultimateoptimizer-remove-wp-embed-js'])) {
    function ultimateoptimizer_remove_wp_embed() {
        if ( ! is_admin() || ! is_user_logged_in() ) {
            wp_deregister_script( 'wp-embed' );
        }
    }
    add_action( 'wp_footer', 'ultimateoptimizer_remove_wp_embed' );
}



// Remove wp-emoji.js
if(!empty($query_conf['ultimateoptimizer-remove-wp-emoji'])) {
    remove_action( 'wp_head', 'print_emoji_detection_script', 7 );
    remove_action( 'wp_print_styles', 'print_emoji_styles' );
}



// Remove wp rsd
if(!empty($query_conf['ultimateoptimizer-remove-wp-rsd'])) {
    remove_action('wp_head', 'rsd_link');
}



// Remove wp generator
if(!empty($query_conf['ultimateoptimizer-remove-wp-gen'])) {
    remove_action('wp_head', 'wp_generator');
}



// Remove wp feed links
if(!empty($query_conf['ultimateoptimizer-remove-wp-feeds'])) {
    remove_action('wp_head', 'feed_links', 2);
}



// Remove wlwmanifest
if(!empty($query_conf['ultimateoptimizer-remove-mfest'])) {
    remove_action('wp_head', 'wlwmanifest_link');
}



// Remove shortlink
if(!empty($query_conf['ultimateoptimizer-remove-wp-shortlink'])) {
    remove_action('wp_head', 'wp_shortlink_wp_head', 10, 0 );
}
