<?php
/**
 *  @copyright 2017  WPVKP  https://wpvkp.com
 *
 *  This plugin is inspired from WP Speed of Light by JoomUnited.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */
defined('ABSPATH') || die('No direct script access allowed!');

class Ultimateoptimizer_Configuration{
    public function __construct()
    {
        add_action( 'load-settings_page_ultimateoptimizer', array($this,'afterLoadConfigPage') );
    }


    /*
     * function to save settings
     */
    public function afterLoadConfigPage()
    {
    	$sites = is_multisite() ? get_sites() : array();
        // Basic options tab
        if (isset($_REQUEST['ultimateoptimizer_basic_action']) && $_REQUEST['ultimateoptimizer_basic_action'] == 'ultimateoptimizer_basic_settings') {
            if (isset($_POST['ultimateoptimizer_settings_basic_nonce']) || wp_verify_nonce($_POST['ultimateoptimizer_settings_basic_nonce'], 'ultimateoptimizer_settings_basic')) {
                WP_Filesystem();

                $basic = array(
                    'ultimateoptimizer-active' =>(isset($_POST['cache-system']) ? '1' : '0'),
                    'ultimateoptimizer-ttl' => (int)$_POST['cache-ttl'],
                    'ultimateoptimizer-minify-html' => (isset($_POST['minification-html']) ? '1' : '0'),
                    'ultimateoptimizer-minify-css' => (isset($_POST['minification-css']) ? '1' : '0'),
                    'ultimateoptimizer-minify-js' => (isset($_POST['minification-js']) ? '1' : '0'),
                    'ultimateoptimizer-desktop-cache' => (int)$_POST['desktop-cache'],
                    'ultimateoptimizer-mobile-cache' => (int)$_POST['mobile-cache'],
                    'ultimateoptimizer-disable-admin' => '1',
                    'ultimateoptimizer-display-clean' => '1',
                    'ultimateoptimizer-include-inline-js' => (isset($_POST['include-inline-js']) ? '1' : '0'),
                    'ultimateoptimizer-include-inline-css' => (isset($_POST['include-inline-css']) ? '1' : '0'),
                );
                update_option('ultimateoptimizer_basic_settings',$basic);

                // Update settings for network sites
                if (is_multisite()) {
                	foreach ($sites as $site) {
                		switch_to_blog($site->blog_id);
		                update_option('ultimateoptimizer_basic_settings',$basic);
	                }
	                restore_current_blog();
                }

                // Storage infomation to cache pages
                Ultimateoptimizer_ConfigCache::factory()->write();
                Ultimateoptimizer_ConfigCache::factory()->write_config_cache();

                // Turn on WP_CACHE to support advanced-cache file
                if (isset($_POST['cache-system'])) {
                    Ultimateoptimizer_ConfigCache::factory()->toggle_caching(true);
                } else {
                    Ultimateoptimizer_ConfigCache::factory()->toggle_caching(false);
                }

                // Reschedule cron events
                if(isset($_POST['cache-system'])){
                    Ultimateoptimizer_PurgeCacheTime::factory()->unschedule_events();
                    Ultimateoptimizer_PurgeCacheTime::factory()->schedule_events();
                }

	            //delete cache after settings
	            do_action('ultimateoptimizer_clear_all_cache');
            }
        }

        // Cleanup Tab
        if (isset($_REQUEST['ultimateoptimizer_must_action']) && $_REQUEST['ultimateoptimizer_must_action'] == 'ultimateoptimizer_must_settings') {
            if (isset($_POST['ultimateoptimizer_settings_must_nonce']) || wp_verify_nonce($_POST['ultimateoptimizer_settings_must_nonce'], 'ultimateoptimizer_settings_must')) {
                $must = array(
                    'ultimateoptimizer-remove-query-strings' =>(isset($_POST['remove-query-strings']) ? '1' : '0'),
                    'ultimateoptimizer-remove-wp-embed-js'   =>(isset($_POST['remove-wp-embed-js']) ? '1' : '0'),
                    'ultimateoptimizer-remove-wp-emoji'      =>(isset($_POST['remove-wp-emoji']) ? '1' : '0'),
                    'ultimateoptimizer-remove-wp-rsd'        =>(isset($_POST['remove-wp-rsd']) ? '1' : '0'),
                    'ultimateoptimizer-remove-wp-gen'        =>(isset($_POST['remove-wp-gen']) ? '1' : '0'),
                    'ultimateoptimizer-remove-wp-feeds'      =>(isset($_POST['remove-wp-feeds']) ? '1' : '0'),
                    'ultimateoptimizer-remove-mfest'         =>(isset($_POST['remove-mfest']) ? '1' : '0'),
                    'ultimateoptimizer-remove-wp-shortlink'  =>(isset($_POST['remove-wp-shortlink']) ? '1' : '0'),
                    'ultimateoptimizer-enable-gzip'          =>(isset($_POST['enable-gzip']) ? '1' : '0'),
                    'ultimateoptimizer-enable-browser-cache' =>(isset($_POST['enable-browser-cache']) ? '1' : '0'),
                    'ultimateoptimizer-unset-etag'           =>(isset($_POST['unset-etag']) ? '1' : '0'),
                );
                update_option('ultimateoptimizer_must_settings',$must);

                // Enables GZip compression
                if(isset($_POST['enable-gzip'])){
                    self::add_gzip_htacess(true);
                }else{
                    self::add_gzip_htacess(false);
                }


                // Enable Browser Cache
                if(isset($_POST['enable-browser-cache'])){
                    self::add_expires_header(true);
                }else{
                    self::add_expires_header(false);
                }


                // Unset E-Tags
                if(isset($_POST['unset-etag'])){
                    self::add_unset_etag(true);
                }else{
                    self::add_unset_etag(false);
                }
            }
        }


        // Advanced options tab
        if (isset($_REQUEST['ultimateoptimizer_advanced_action']) && $_REQUEST['ultimateoptimizer_advanced_action'] == 'ultimateoptimizer_advanced_settings') {
            if (isset($_POST['ultimateoptimizer_settings_advanced_nonce']) || wp_verify_nonce($_POST['ultimateoptimizer_settings_advanced_nonce'], 'ultimateoptimizer_settings_advanced')) {
                $exclude_urls = $this->string_convert_arr(sanitize_textarea_field($_POST['exclude-urls']));
                $exclude_css = $this->string_convert_arr(sanitize_textarea_field($_POST['exclude-css']));
                $exclude_js = $this->string_convert_arr(sanitize_textarea_field($_POST['exclude-js']));
                $move_to_footer_js = $defer_js = array();

                if (!empty($_POST['move-to-footer-js'])) {
                    foreach ($_POST['move-to-footer-js'] as $url) {
                        if (trim($url) == '') continue;
                        $url = current(explode('?', $url, 2));
                        $move_to_footer_js[sanitize_text_field($url)] = sanitize_text_field($url);
                    }
                }

                if (!empty($_POST['defer-js'])) {
                    foreach ($_POST['defer-js'] as $url) {
                        if (trim($url) == '') continue;
                        $url = current(explode('?', $url, 2));
                        $defer_js[sanitize_text_field($url)] = sanitize_text_field($url);
                    }
                }

                $advanced = array(
                    'ultimateoptimizer-exclude-urls' => $exclude_urls,
                    'ultimateoptimizer-group-css' => (isset($_POST['group-css']) ? '1' : '0'),
                    'ultimateoptimizer-group-js' => (isset($_POST['group-js']) ? '1' : '0'),
                    'ultimateoptimizer-exclude-css' => $exclude_css,
                    'ultimateoptimizer-exclude-js' => $exclude_js,
                    'ultimateoptimizer-move-to-footer-js' => $move_to_footer_js,
                    'ultimateoptimizer-defer-js' => $defer_js
                );
                update_option('ultimateoptimizer_advanced_settings',$advanced);
	            // Update settings for network sites
	            if (is_multisite()) {
		            foreach ($sites as $site) {
			            switch_to_blog($site->blog_id);
			            update_option('ultimateoptimizer_advanced_settings',$advanced);
		            }
		            restore_current_blog();
	            }

                WP_Filesystem();
                // Storage infomation to cache pages
                Ultimateoptimizer_ConfigCache::factory()->write_config_cache();

                //delete cache after settings
                do_action('ultimateoptimizer_clear_all_cache');
            }
        }

        // Database option tab
        if (isset($_REQUEST['ultimateoptimizer_database_action']) && $_REQUEST['ultimateoptimizer_database_action'] == 'ultimateoptimizer_database_settings') {
            if (isset($_POST['ultimateoptimizer_settings_database_nonce']) || wp_verify_nonce($_POST['ultimateoptimizer_settings_database_nonce'], 'ultimateoptimizer_settings_database')) {
                if(isset($_POST['clean'])){
                	if (is_multisite()) {
		                foreach ($sites as $site) {
		                	switch_to_blog($site->blog_id);
			                foreach ($_POST['clean'] as $item){
				                $this->cleanSystem($item);
			                }
		                }
		                restore_current_blog();
	                } else {
		                foreach ($_POST['clean'] as $item){
			                $this->cleanSystem($item);
		                }
	                }

                    //return current page
                    if (!empty($_REQUEST['_wp_http_referer'])) {
                        wp_redirect($_REQUEST['_wp_http_referer'].'&database-cleanup=success');
                        exit;
                    }
                }
            }
        }

        // Cdn option tab
        if (isset($_REQUEST['ultimateoptimizer_cdn_action']) && $_REQUEST['ultimateoptimizer_cdn_action'] == 'ultimateoptimizer_cdn_settings') {
            if (isset($_POST['ultimateoptimizer_settings_cdn_nonce']) || wp_verify_nonce($_POST['ultimateoptimizer_settings_cdn_nonce'], 'ultimateoptimizer_settings_cdn')) {
                $cdn_content = array();
                $exclude_content = array();
                if(!empty($_POST['cdn-content'])){
                    $cdn_content = explode(',',sanitize_text_field($_POST['cdn-content']));
                    $cdn_content = array_unique($cdn_content);
                }
                if(!empty($_POST['cdn-exclude-content'])){
                    $exclude_content = explode(',',sanitize_text_field($_POST['cdn-exclude-content']));
                    $exclude_content = array_unique($exclude_content);
                }

                $cdn = array(
                    'cdn-active' => (isset($_POST['activate-cdn']) ? '1' : '0'),
                    'cdn-url' =>(isset($_POST['cdn-url']) ? sanitize_text_field($_POST['cdn-url']) : ''),
                    'cdn-content' => $cdn_content,
                    'cdn-exclude-content' => $exclude_content,
                    'cdn-relative-path' =>(isset($_POST['cdn-relative-path']) ? '1' : '0'),
                );

                update_option('ultimateoptimizer_cdn_integration', $cdn);
	            // Update settings for network sites
	            if (is_multisite()) {
		            foreach ($sites as $site) {
			            switch_to_blog($site->blog_id);
			            update_option('ultimateoptimizer_cdn_integration',$cdn);
		            }
		            restore_current_blog();
	            }

	            //delete cache after settings
	            do_action('ultimateoptimizer_clear_all_cache');
            }
        }

        // Varnish option tab
        if (isset($_REQUEST['ultimateoptimizer_varnish_action']) && $_REQUEST['ultimateoptimizer_varnish_action'] == 'ultimateoptimizer_varnish_settings') {
            if (isset($_POST['ultimateoptimizer_settings_varnish_nonce']) || wp_verify_nonce($_POST['ultimateoptimizer_settings_varnish_nonce'], 'ultimateoptimizer_settings_varnish')) {
                $varnish = array(
                    'auto-purge-varnish' => (isset($_POST['auto-purge-varnish']) ? '1' : '0'),
                    'ultimateoptimizer-varnish-server-ip' => preg_replace('/[^a-zA-Z0-9\-\_\.]*/','',$_POST['varnish-server-ip'])
                );
                update_option('ultimateoptimizer_varnish_cache',$varnish);
	            // Update settings for network sites
	            if (is_multisite()) {
		            foreach ($sites as $site) {
			            switch_to_blog($site->blog_id);
			            update_option('ultimateoptimizer_varnish_cache',$varnish);
		            }
		            restore_current_blog();
	            }

                // Clear varnish cache after settings
	            do_action('ultimateoptimizer_clear_varnish');
            }
        }


        //return current page
        if (!empty($_REQUEST['_wp_http_referer'])) {
            wp_redirect($_REQUEST['_wp_http_referer'].'&save-settings=success');
            exit;
        }

        return true;
    }


    public static function remove_query_strings_random98608() {
        include_once(ULTIMATEOPTIMIZER_PLUGIN_DIR . 'inc/ultimateoptimizer-cleanup.php');
    }
        

    /*
    * function add expires header to .htaccess
    */
    public static function add_expires_header($check) {
        $expires = "\r\n#Ultimate Optimizer Plugin Expires Headers" . PHP_EOL .
            "<IfModule mod_expires.c>" . PHP_EOL .
            "   ExpiresActive On" . PHP_EOL .
            "   ExpiresDefault A2592000" . PHP_EOL .
            "   ExpiresByType application/javascript \"access plus 7 days\"" . PHP_EOL .
            "   ExpiresByType text/javascript \"access plus 7 days\"" . PHP_EOL .
            "   ExpiresByType text/css \"access plus 7 days\"" . PHP_EOL .
            "   ExpiresByType image/jpeg \"access plus 7 days\"" . PHP_EOL .
            "   ExpiresByType image/png \"access plus 7 days\"" . PHP_EOL .
            "   ExpiresByType image/gif \"access plus 7 days\"" . PHP_EOL .
            "   ExpiresByType image/ico \"access plus 7 days\"" . PHP_EOL .
            "   ExpiresByType image/x-icon \"access plus 7 days\"" . PHP_EOL .
            "   ExpiresByType image/svg+xml \"access plus 7 days\"" . PHP_EOL .
            "   ExpiresByType image/bmp \"access plus 7 days\"" . PHP_EOL .
            "</IfModule>" . PHP_EOL .
            "#End Enjoy Better Site Performance\r\n" . PHP_EOL ;

        if ($check) {
            if (!is_super_admin()) {
                return FALSE;
            }
            //open htaccess file
            $htaccessContent = file_get_contents(ABSPATH . DIRECTORY_SEPARATOR . '.htaccess');
            if (empty($htaccessContent)) {
                return FALSE;
            }
            //if isset expires header in htacces
            if (strpos($htaccessContent, 'mod_expires') !== false || strpos($htaccessContent, 'ExpiresActive') !== false || strpos($htaccessContent, 'ExpiresDefault') !== false || strpos($htaccessContent, 'ExpiresByType') !== false) {
                return FALSE;
            }

            $htaccessContent = $expires.$htaccessContent;
            file_put_contents(ABSPATH . DIRECTORY_SEPARATOR . '.htaccess', $htaccessContent);
            return TRUE;

        } else {
            if (!is_super_admin()) {
                return FALSE;
            }
            //open htaccess file
            $htaccessContent = file_get_contents(ABSPATH . DIRECTORY_SEPARATOR . '.htaccess');
            if (empty($htaccessContent)) {
                return FALSE;
            }

            $pattern = '/#Ultimate Optimizer Plugin Expires Headers[\s\S]*#End Enjoy Better Site Performance/im';

            $htaccessContent = preg_replace($pattern,'',$htaccessContent);
            file_put_contents(ABSPATH . DIRECTORY_SEPARATOR . '.htaccess', $htaccessContent);
            return TRUE;
        }
    }
    /*
   * function add gzip header to .htaccess
   */
    public static function add_gzip_htacess($check){
        $data = "\r\n# Begin Increase_WordPress_Speed_Plugin_Gzip".PHP_EOL.
            "<IfModule mod_deflate.c>".PHP_EOL.
            "AddType x-font/woff .woff".PHP_EOL.
            "AddOutputFilterByType DEFLATE image/svg+xml".PHP_EOL.
            "AddOutputFilterByType DEFLATE text/plain".PHP_EOL.
            "AddOutputFilterByType DEFLATE text/html".PHP_EOL.
            "AddOutputFilterByType DEFLATE text/xml".PHP_EOL.
            "AddOutputFilterByType DEFLATE text/css".PHP_EOL.
            "AddOutputFilterByType DEFLATE text/javascript".PHP_EOL.
            "AddOutputFilterByType DEFLATE application/xml".PHP_EOL.
            "AddOutputFilterByType DEFLATE application/xhtml+xml".PHP_EOL.
            "AddOutputFilterByType DEFLATE application/rss+xml".PHP_EOL.
            "AddOutputFilterByType DEFLATE application/javascript".PHP_EOL.
            "AddOutputFilterByType DEFLATE application/x-javascript".PHP_EOL.
            "AddOutputFilterByType DEFLATE application/x-font-ttf".PHP_EOL.
            "AddOutputFilterByType DEFLATE application/vnd.ms-fontobject".PHP_EOL.
            "AddOutputFilterByType DEFLATE font/opentype font/ttf font/eot font/otf".PHP_EOL.
            "</IfModule>".PHP_EOL.
            "# End Increase_WordPress_Speed_Plugin_Gzip\r\n" . PHP_EOL ;
        if ($check) {
            if (!is_super_admin()) {
                return FALSE;
            }
            //open htaccess file
            $htaccessContent = file_get_contents(ABSPATH . DIRECTORY_SEPARATOR . '.htaccess');
            if (empty($htaccessContent)) {
                return FALSE;
            }
            //if isset Gzip access
            if (strpos($htaccessContent, 'mod_deflate') !== false || strpos($htaccessContent, 'AddOutputFilterByType') !== false || strpos($htaccessContent, 'AddType') !== false || strpos($htaccessContent,'Increase_WordPress_Speed_Plugin_Gzip') !== false) {
                return FALSE;
            }

            $htaccessContent = $data.$htaccessContent;
            file_put_contents(ABSPATH . DIRECTORY_SEPARATOR . '.htaccess', $htaccessContent);
            return TRUE;

        } else {
            if (!is_super_admin()) {
                return FALSE;
            }
            //open htaccess file
            $htaccessContent = file_get_contents(ABSPATH . DIRECTORY_SEPARATOR . '.htaccess');
            if (empty($htaccessContent)) {
                return FALSE;
            }

	        $pattern = '/# Begin Increase_WordPress_Speed_Plugin_Gzip[\s\S]*# End Increase_WordPress_Speed_Plugin_Gzip/im';

	        $htaccessContent = preg_replace($pattern,'',$htaccessContent);
            file_put_contents(ABSPATH . DIRECTORY_SEPARATOR . '.htaccess', $htaccessContent);
            return TRUE;
        }
    }


    /*
    * Add Unset E-Tag To The .htaccess File
    */
    public static function add_unset_etag($check) {
        $expires = "\r\n#Ultimate Optimizer Plugin Unset E-tags" . PHP_EOL .
            '<filesMatch "\.(html|htm|js|css)$">' . PHP_EOL .
            "   FileETag None" . PHP_EOL .
            "   <ifModule mod_headers.c>" . PHP_EOL .
            "   Header unset ETag" . PHP_EOL .
            '   Header set Cache-Control "max-age=0, no-cache, no-store, must-revalidate"' . PHP_EOL .
            '   Header set Pragma "no-cache"' . PHP_EOL .
            '   Header set Expires "Wed, 11 Jan 1984 05:00:00 GMT'. PHP_EOL .
            "   </ifModule>" . PHP_EOL .
            "</filesMatch>" . PHP_EOL .
            "#End of E-Tags\r\n" . PHP_EOL ;

        if ($check) {
            if (!is_super_admin()) {
                return FALSE;
            }
            //open htaccess file
            $htaccessContent = file_get_contents(ABSPATH . DIRECTORY_SEPARATOR . '.htaccess');
            if (empty($htaccessContent)) {
                return FALSE;
            }
            //if isset expires header in htacces
            if (strpos($htaccessContent, 'mod_headers') !== false || strpos($htaccessContent, 'FileETag') !== false) {
                return FALSE;
            }

            $htaccessContent = $expires.$htaccessContent;
            file_put_contents(ABSPATH . DIRECTORY_SEPARATOR . '.htaccess', $htaccessContent);
            return TRUE;

        } else {
            if (!is_super_admin()) {
                return FALSE;
            }
            //open htaccess file
            $htaccessContent = file_get_contents(ABSPATH . DIRECTORY_SEPARATOR . '.htaccess');
            if (empty($htaccessContent)) {
                return FALSE;
            }

            $pattern = '/#Ultimate Optimizer Plugin Unset E-tags[\s\S]*#End of E-Tags/im';

            $htaccessContent = preg_replace($pattern,'',$htaccessContent);
            file_put_contents(ABSPATH . DIRECTORY_SEPARATOR . '.htaccess', $htaccessContent);
            return TRUE;
        }
    }


    /*
    * Database clean tab
    * funtion to clean in database
    */
    public static function cleanSystem($type){
        global $wpdb;
        $clean = "";

        switch ($type){
            case "revisions":
                $clean = "DELETE FROM `$wpdb->posts` WHERE post_type = 'revision';";
                $revisions = $wpdb->query( $clean );

                $message = "All post revisions";
                break;
            case "drafted":
                $clean = "DELETE FROM `$wpdb->posts` WHERE post_status = 'auto-draft';";
                $autodraft = $wpdb->query( $clean );

                $message = "All auto drafted content";
                break;
            case "trash":
                $clean = "DELETE FROM `$wpdb->posts` WHERE post_status = 'trash';";
                $posttrash = $wpdb->query( $clean );

                $message = "All trashed content";
                break;
            case "comments":
                $clean = "DELETE FROM `$wpdb->comments` WHERE comment_approved = 'spam' OR comment_approved = 'trash' ;";
                $comments = $wpdb->query( $clean );

                $message = "Comments from trash & spam";
                break;
            case "trackbacks":
                $clean = "DELETE FROM `$wpdb->comments` WHERE comment_type = 'trackback' OR comment_type = 'pingback' ;";
                $comments = $wpdb->query( $clean );

                $message = "Trackbacks and pingbacks";
                break;
            case "transient":
                $clean = "DELETE FROM `$wpdb->options` WHERE option_name LIKE '%\_transient\_%' ;";
                $comments = $wpdb->query( $clean );

                $message = "Transient options";
                break;
        }

        return true;
    }

    /*
     * Database clean tab
     * funtion to get number of element to clean in database
     */
    public static function getElementToClean($type){
        global $wpdb;
        $return = 0;
        switch ($type){
            case "revisions":
                $element = "SELECT ID FROM `$wpdb->posts` WHERE post_type = 'revision';";
                $return = $wpdb->query( $element );
                break;
            case "drafted":
                $element = "SELECT ID FROM `$wpdb->posts` WHERE post_status = 'auto-draft';";
                $return = $wpdb->query( $element );
                break;
            case "trash":
                $element = "SELECT ID FROM `$wpdb->posts` WHERE post_status = 'trash';";
                $return = $wpdb->query( $element );
                break;
            case "comments":
                $element = "SELECT comment_ID FROM `$wpdb->comments` WHERE comment_approved = 'spam' OR comment_approved = 'trash' ;";
                $return = $wpdb->query( $element );
                break;
            case "trackbacks":
                $element = "SELECT comment_ID FROM `$wpdb->comments` WHERE comment_type = 'trackback' OR comment_type = 'pingback' ;";
                $return = $wpdb->query( $element );
                break;
            case "transient":
                $element = "SELECT option_id FROM `$wpdb->options` WHERE option_name LIKE '%\_transient\_%' ;";
                $return = $wpdb->query( $element );
                break;
        }
        return $return;
    }

    // Convert string to array
    protected function string_convert_arr($input){
        $output = array();
        if(!empty($input)){
            $input = rawurldecode($input);
            $input = trim($input);
            $input = str_replace(' ', '', $input);
            $input = explode("\n",$input);

            foreach ($input as $k => $v){
                $output[] = trim($v);
            }
        }
        return $output;
    }
    //ajax clean cache
    public static function ultimateoptimizer_clean_cache() {
        $size_cache = 0;
        $size_css_cache = 0;
        $size_js_cache = 0;
        $result = 0;
        // analysis size cache
        $cachepath = rtrim(WP_CONTENT_DIR, '/') . '/cache/ultimateoptimizer';

        if (is_dir($cachepath))
            $cachedirs = scandir($cachepath);
        if (!empty($cachedirs)) {
            foreach ($cachedirs as $cachedir) {
                if ($cachedir != '.' && $cachedir != '..') {
                    $filepath = $cachepath . '/' . $cachedir;
                    if(is_dir($filepath))
                        $filedirs = scandir($filepath);
                    foreach($filedirs as $filedir){
                        if ($filedir != '.' && $filedir != '..') {
                            if (@file_exists($filepath)) {
                                $dir_path = $filepath.'/'.$filedir;
                                $size_cache += filesize($dir_path);
                            }
                        }
                    }

                }
            }
        }

        // analysis size css cache
        if(is_multisite()){
            $blog_id = get_current_blog_id();
            $css_path = rtrim(WP_CONTENT_DIR, '/') . '/cache/ultimateoptimizer-minification/'.$blog_id.'/css';
        }else{
            $css_path = rtrim(WP_CONTENT_DIR, '/') . '/cache/ultimateoptimizer-minification/css';
        }
        if (is_dir($css_path))
            $file_in_css = scandir($css_path);
        if (!empty($file_in_css)) {
            foreach ($file_in_css as $v) {
                if ($v != '.' && $v != '..' && $v != 'index.html') {
                    $path = $css_path . '/' . $v;
                    $size_css_cache += filesize($path);
                }
            }
        }

        // analysis size js cache
        if(is_multisite()){
            $blog_id = get_current_blog_id();
            $js_path = rtrim(WP_CONTENT_DIR, '/') . '/cache/ultimateoptimizer-minification/'.$blog_id.'/js';
        }else{
            $js_path = rtrim(WP_CONTENT_DIR, '/') . '/cache/ultimateoptimizer-minification/js';
        }
        if (is_dir($js_path))
            ;
        $file_in_js = scandir($js_path);
        if (!empty($file_in_js)) {
            foreach ($file_in_js as $v) {
                if ($v != '.' && $v != '..' && $v != 'index.html') {
                    $path = $js_path . '/' . $v;
                    $size_js_cache += filesize($path);
                }
            }
        }

        $total_size_cache = $size_cache + $size_css_cache + $size_js_cache;

        $result = self::formatBytes($total_size_cache);

        //delete minify file
        Ultimateoptimizer_MinificationCache::clear_minification();
        //delete all cache
        Ultimateoptimizer_PurgeCache::ultimateoptimizer_cache_flush();

        return $result;
    }

    /*
     *Ajax clean cache
     *
     */
    public static function ultimateoptimizer_ajax_clean_cache(){
        //check security nonce
        check_ajax_referer( '_ultimateoptimizer_purge_cache', 'security' );
        $result = self::ultimateoptimizer_clean_cache();

        echo json_encode($result);
        exit;
    }
    /*
     * Ajax purge varnish
     */
    public static function purge_varnish_action(){
        //check security
        check_ajax_referer( '_ultimateoptimizer_purge_varnish', 'security' );

	    do_action('ultimateoptimizer_clear_varnish');

        echo json_encode(array('clear' => true));
        exit;
    }
    /*
     * Ajax purge database
     */
    public static function ultimateoptimizer_ajax_purge_database(){
        //check security
        check_ajax_referer( '_ultimateoptimizer_purge_database', 'security' );

        $type = array('revisions','drafted','trash','comments','trackbacks','transient');
        foreach ($type as $item){
            self::cleanSystem($item);
        }

        echo json_encode(array('clear' => true));
        exit;
    }
    public static function formatBytes($bytes, $precision = 2) {
        if ($bytes >= 1073741824) {
            $bytes = number_format($bytes / 1073741824, 2);
        } elseif ($bytes >= 1048576) {
            $bytes = number_format($bytes / 1048576, 2);
        } elseif ($bytes >= 1024) {
            $bytes = number_format($bytes / 1024, 2);
        } elseif ($bytes > 1) {
            $bytes = $bytes;
        } elseif ($bytes == 1) {
            $bytes = $bytes;
        } else {
            $bytes = '0';
        }

        return $bytes;
    }

}

//init configuration object
new Ultimateoptimizer_Configuration();
