<?php
/**
 * Plugin Name: Ultimate Optimizer
 * Description: Ultimateoptimizer is a WordPress cache plugin with extensive options to speed up your website. All the options including Varnish Cache are compatible with WPVKP hosting.
 * Version: 1.6
 * Text Domain: ultimateoptimizer
 * Domain Path: /languages
 * Author: WPVKP
 * Author URI: https://wpvkp.com
 * License: GPL2
 */

/**
 *  @copyright 2017  WPVKP  https://wpvkp.com
 *
 *  This plugin is inspired from WP Speed of Light by JoomUnited.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

defined('ABSPATH') || die('No direct script access allowed!');

if (!defined('ULTIMATEOPTIMIZER_PLUGIN_DIR'))
    define('ULTIMATEOPTIMIZER_PLUGIN_DIR', plugin_dir_path(__FILE__));
if (!defined('ULTIMATEOPTIMIZER_VERSION'))
    define('ULTIMATEOPTIMIZER_VERSION','1.0.1');
if (!defined('ULTIMATEOPTIMIZER_SITEURL'))
    define('ULTIMATEOPTIMIZER_SITEURL', get_site_url());
if (!defined('ULTIMATEOPTIMIZER_MINIFICATION_CACHE'))
    define('ULTIMATEOPTIMIZER_MINIFICATION_CACHE', WP_CONTENT_DIR . '/cache/ultimateoptimizer-minification/');
if (!defined('ULTIMATEOPTIMIZER_CACHEFILE_PREFIX'))
    define('ULTIMATEOPTIMIZER_CACHEFILE_PREFIX', 'ultimateoptimizer_');
if (!defined('ULTIMATEOPTIMIZER_CACHE_CHILD_DIR'))
    define('ULTIMATEOPTIMIZER_CACHE_CHILD_DIR', '/cache/ultimateoptimizer-minification/');
if (!defined('ULTIMATEOPTIMIZER_WP_CONTENT_NAME'))
    define('ULTIMATEOPTIMIZER_WP_CONTENT_NAME', '/' . wp_basename(WP_CONTENT_DIR));
if (!defined('ULTIMATEOPTIMIZER_BASENAME'))
    define('ULTIMATEOPTIMIZER_BASENAME',plugin_basename(__FILE__));

define('ULTIMATEOPTIMIZER_CACHE_DELAY', true);
define('ULTIMATEOPTIMIZER_CACHE_NOGZIP', true);
define('ULTIMATEOPTIMIZER_ROOT_DIR', str_replace(ULTIMATEOPTIMIZER_WP_CONTENT_NAME, '', WP_CONTENT_DIR));
//action to purge cache
require_once(ULTIMATEOPTIMIZER_PLUGIN_DIR . 'inc/cache/purge-varnish.php');
require_once(ULTIMATEOPTIMIZER_PLUGIN_DIR . 'inc/cache/purge-cache.php');
require_once(ULTIMATEOPTIMIZER_PLUGIN_DIR . 'inc/cache/purge-per-time.php');

// Activate plugin hook
register_activation_hook(__FILE__,array('Ultimateoptimizer_Admin','plugin_active_hook'));
//Deactivate plugin hook
register_deactivation_hook(__FILE__,array('Ultimateoptimizer_Admin','plugin_deactive_hook'));

if(is_admin()){
    require_once(ULTIMATEOPTIMIZER_PLUGIN_DIR . 'inc/ultimateoptimizer-admin.php');
    require_once(ULTIMATEOPTIMIZER_PLUGIN_DIR . 'inc/ultimateoptimizer-configuration.php');
    //config to cache
    require_once(ULTIMATEOPTIMIZER_PLUGIN_DIR . 'inc/cache/config-cache.php');

	//cache when ecommerce installed
	require_once( ULTIMATEOPTIMIZER_PLUGIN_DIR . 'inc/cache/ecommerce-cache.php');
	new Ultimateoptimizer_Ecommerce_Cache();
}else{
    $cdn_conf = get_option('ultimateoptimizer_cdn_integration');
    $basic_conf = get_option('ultimateoptimizer_basic_settings');

    if(!empty($cdn_conf['cdn-active']) || !empty($basic_conf['ultimateoptimizer-minify-js']) || !empty($basic_conf['ultimateoptimizer-minify-css']) || !empty($basic_conf['ultimateoptimizer-minify-html'])) {
        // Call back ob start
        ob_start('ultimateoptimizer_ob_start_callback');
    }
}

// Call back ob start - stack
function ultimateoptimizer_ob_start_callback($buffer){
    $conf = get_option('ultimateoptimizer_cdn_integration');
    // Get buffer from minify
    $buffer = apply_filters('ultimateoptimizer_minify_content_return',$buffer);

    if(!empty($conf) || !empty($conf['cdn-active'])){
        // Get buffer after remove query strings
        $buffer = apply_filters('ultimateoptimizer_cdn_content_return',$buffer);
    }
    // Return content
    return $buffer;
}

// Minify
require_once(ULTIMATEOPTIMIZER_PLUGIN_DIR . 'inc/minification/ultimateoptimizer-minify-main.php');
require_once(ULTIMATEOPTIMIZER_PLUGIN_DIR . 'inc/minification/ultimateoptimizer-minification-cache.php');
new Ultimateoptimizer_Minify();
// CDN Integration
if( !class_exists('Ultimateoptimizer_CDN_Integration')){
    require_once ( ULTIMATEOPTIMIZER_PLUGIN_DIR. 'inc/cdn-integration/ultimateoptimizer-cdn-integration.php');
    require_once ( ULTIMATEOPTIMIZER_PLUGIN_DIR. 'inc/cdn-integration/ultimateoptimizer-cdn-rewrite.php');
    new Ultimateoptimizer_CDN_Integration();
}


// Must Clean Functions Loadup
require_once(ULTIMATEOPTIMIZER_PLUGIN_DIR . 'inc/ultimateoptimizer-cleanup.php');
