<?php
    defined('ABSPATH') or die;

    $advanced = get_option('ultimateoptimizer_advanced_settings');
?>
<div class="iws-advanced">
    <h2>
        <span class="iws-icon">
            <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 224 224"><g fill="none" stroke-miterlimit="10" font-family="none" font-size="none" font-weight="none" style="mix-blend-mode:normal" text-anchor="none"><path d="M0 224V0h224v224z"/><path fill="#ff9800" d="M144.667 205.333V183.86l12.14 2.334c13.526 2.807 26.123-7 27.052-20.526l2.808-30.334 13.526-5.596c4.666-1.878 6.544-7.474 3.737-12.14l-17.263-28.93c-2.808-35.474-22.86-70-74.667-70-53.193 0-79.333 39.192-79.333 79.333 0 17.263 6.07 32.193 15.403 44.807 8.404 11.667 12.597 25.667 12.597 39.667v22.385h84z"/><path fill="#fff" d="M143.263 106.86c0-1.386.474-2.79.474-4.193 0-1.404 0-2.808-.474-4.193l8.878-6.544c.93-.456.93-1.86.455-2.79l-8.403-14.947c-.456-.93-1.86-1.386-2.79-.93l-9.807 4.667c-2.333-1.86-4.666-3.263-7.455-4.193L123.193 63c0-.93-.93-1.86-1.86-1.86H104.07c-.93 0-1.877.93-1.877 1.86l-.93 10.737c-2.789.93-5.122 2.789-7.456 4.193L84 73.263c-.93-.456-2.333 0-2.807.93L72.807 89.14c-.474.93-.474 2.333.456 2.789l8.878 6.544c0 1.385-.474 2.789-.474 4.193 0 1.403 0 2.807.474 4.192l-8.878 6.545c-.93.455-.93 1.859-.456 2.789l8.386 14.948c.474.93 1.877 1.385 2.807.93l9.807-4.667c2.334 1.859 4.667 3.263 7.456 4.192l.93 10.737c0 .93.948 1.86 1.877 1.86h17.263c.93 0 1.86-.93 1.86-1.86l.948-10.737c2.789-.93 5.122-2.789 7.455-4.192l9.808 4.666c.93.456 2.333 0 2.789-.93l8.403-14.947c.474-.93.474-2.334-.455-2.79zM112 119c-8.86 0-16.333-7-16.333-16.333 0-8.86 7-16.334 16.333-16.334 8.86 0 16.333 7 16.333 16.334 0 8.859-7.474 16.333-16.333 16.333z"/></g></svg>
        </span>
        Advanced Settings
    </h2>
    <table>
        <tr>
            <td>
                <label><?php _e('Group Files', 'ultimateoptimizer'); ?></label>
            </td>
            <td>
                <ul>
                    <li>
                        <input type="checkbox" class="chkbx-toggle" name="group-css" id="group-css"
                               value="1" <?php checked($advanced['ultimateoptimizer-group-css'],'1')?>/>
                               <label for="group-css"></label>
                        <label for="group-css"><?php _e('CSS','ultimateoptimizer')?></label>
                    </li>
                    <li>
                        <input type="checkbox" class="chkbx-toggle" name="group-js" id="group-js"
                               value="1" <?php checked($advanced['ultimateoptimizer-group-js'],'1')?>/>
                               <label for="group-js"></label>
                        <label for="group-js"><?php _e('JS','ultimateoptimizer')?></label>
                    </li>
                    <li>
                        <span>
                            <b>Note:&nbsp;</b><?php _e('Combine JS & CSS into one file', 'ultimateoptimizer') ?><br>
                            <b><?php _e('Important: Enable Minification to use this option.','ultimateoptimizer')?></b>
                        </span>
                    </li>
                </ul>
            </td>
        </tr>
        <tr>
            <td>
                <label for="exclude-css"><?php _e('Exclude CSS', 'ultimateoptimizer') ?></label>
            </td>
            <td>
                <textarea cols="100" rows="7" id="exclude-css"
                          name="exclude-css"><?php if (!empty($advanced['ultimateoptimizer-exclude-css'])) {
                        $output = implode("\n", $advanced['ultimateoptimizer-exclude-css']);
                        echo esc_textarea($output);
                    } ?></textarea>
                <br/>
                <span><b>Note:&nbsp;</b><?php _e('Use this option to exclude CSS files from Minification and Grouping. Enter the URLs of CSS files on each line.', 'ultimateoptimizer') ?></span>
            </td>
        </tr>
        <tr>
            <td>
                <label for="exclude-js"><?php _e('Exclude JS', 'ultimateoptimizer') ?></label>
            </td>
            <td>
                <textarea cols="100" rows="7" id="exclude-js"
                          name="exclude-js"><?php if (!empty($advanced['ultimateoptimizer-exclude-js'])) {
                        $output = implode("\n", $advanced['ultimateoptimizer-exclude-js']);
                        echo esc_textarea($output);
                    } ?></textarea>
                <br/>
                <span><b>Note:&nbsp;</b><?php _e('Use this option to exclude JS files from Minification and Grouping. Enter the URLs of JS files on each line.', 'ultimateoptimizer') ?></span>
            </td>
        </tr>
        <tr>
            <td>
                <label for="move-to-footer-js"><?php _e('Move JS files to footer', 'ultimateoptimizer') ?></label>
            </td>
            <td>
                <div class="ultimateoptimizer-list-url">
                <?php if (!empty($advanced['ultimateoptimizer-move-to-footer-js'])) : ?>
                    <?php foreach ($advanced['ultimateoptimizer-move-to-footer-js'] as $js_url) : ?>
                    <div class="ultimateoptimizer-input-group">
                        <span class="sort-handle">
                            <span class="dashicons dashicons-arrow-up moveUp"></span>
                            <span class="dashicons dashicons-arrow-down moveDown"></span>
                        </span>
                        <input type="text" size="98"
                               class="ultimateoptimizer-input-url"
                               name="move-to-footer-js[]"
                               placeholder="<?php _e('Enter URL...', 'ultimateoptimizer') ?>"
                               value="<?php echo esc_html($js_url) ?>" />
                        <span class="dashicons dashicons-no item-remove" title="<?php _e('Remove', 'ultimateoptimizer') ?>"></span>
                    </div>
                    <?php endforeach; ?>
                <?php else : ?>
                    <div class="ultimateoptimizer-input-group">
                        <span class="sort-handle">
                            <span class="dashicons dashicons-arrow-up moveUp"></span>
                            <span class="dashicons dashicons-arrow-down moveDown"></span>
                        </span>
                        <input type="text" size="98"
                               class="ultimateoptimizer-input-url"
                               id="move-to-footer-js"
                               name="move-to-footer-js[]"
                               placeholder="<?php _e('Enter URL...', 'ultimateoptimizer') ?>"
                               value="" />
                        <span class="dashicons dashicons-no" title="<?php _e('Remove', 'ultimateoptimizer') ?>"></span>
                    </div>
                <?php endif; ?>
                </div>
                <div style="margin: 10px 0">
                    <button type="button" class="button add-url" id="add-move-to-footer-js">
                        <?php _e('Add URL', 'ultimateoptimizer') ?>
                    </button>
                </div>
                <div>
                    <span>
                        <b>Note:&nbsp;</b>
                        <?php _e('Enter the complete URLs of JS files to be moved to the footer during minification process.', 'ultimateoptimizer') ?>
                    </span>
                    <span>
                        <?php _e('You should add the URL of original files as URL of minified files are not supported.', 'ultimateoptimizer') ?>
                    </span>
                </div>
            </td>
        </tr>
        <tr>
            <td>
                <label for="defer-js"><?php _e('JS files with deferred loading', 'ultimateoptimizer') ?></label>
            </td>
            <td>
                <div class="ultimateoptimizer-list-url">
                    <?php if (!empty($advanced['ultimateoptimizer-defer-js'])) : ?>
                        <?php foreach ($advanced['ultimateoptimizer-defer-js'] as $js_url) : ?>
                            <div class="ultimateoptimizer-input-group">
                                <span class="sort-handle">
                                    <span class="dashicons dashicons-arrow-up moveUp"></span>
                                    <span class="dashicons dashicons-arrow-down moveDown"></span>
                                </span>
                                <input type="text" size="98"
                                       class="ultimateoptimizer-input-url"
                                       name="defer-js[]"
                                       placeholder="<?php _e('Enter URL...', 'ultimateoptimizer') ?>"
                                       value="<?php echo esc_html($js_url) ?>" />
                                <span class="dashicons dashicons-no item-remove" title="<?php _e('Remove', 'ultimateoptimizer') ?>"></span>
                            </div>
                        <?php endforeach; ?>
                    <?php else : ?>
                        <div class="ultimateoptimizer-input-group">
                            <span class="sort-handle">
                                <span class="dashicons dashicons-arrow-up moveUp"></span>
                                <span class="dashicons dashicons-arrow-down moveDown"></span>
                            </span>
                            <input type="text" size="98"
                                   class="ultimateoptimizer-input-url"
                                   name="defer-js[]"
                                   id="defer-js"
                                   placeholder="<?php _e('Enter URL...', 'ultimateoptimizer') ?>"
                                   value="" />
                            <span class="dashicons dashicons-no item-remove" title="<?php _e('Remove', 'ultimateoptimizer') ?>"></span>
                        </div>
                    <?php endif; ?>
                </div>
                <div style="margin: 10px 0">
                    <button type="button" class="button add-url" id="add-defer-js">
                        <?php _e('Add URL', 'ultimateoptimizer') ?>
                    </button>
                </div>
                <div>
                    <span>
                        <b>Note:&nbsp;</b>
                        <?php _e('You should add the URL of original files as URL of minified files are not supported.', 'ultimateoptimizer') ?>
                    </span>
                </div>
            </td>
        </tr>
        <tr>
            <td>
                <label for="exclude-urls"><?php _e('Never Cache these URLs', 'ultimateoptimizer'); ?></label>
            </td>
            <td>
                <textarea cols="100" rows="7" id="exclude-urls"
                             name="exclude-urls"><?php if (!empty($advanced['ultimateoptimizer-exclude-urls'])) {
                        $output = implode("\n", $advanced['ultimateoptimizer-exclude-urls']);
                        echo esc_textarea($output);
                    } ?></textarea>
                <br/>
                <span><b>Note:&nbsp;</b><?php _e('Add post or page url you dont this plugin to cache.','ultimateoptimizer') ?></span>
            </td>
        </tr>
    </table>

</div>