<?php
defined('ABSPATH') or die;

$basic = get_option('ultimateoptimizer_basic_settings');
?>

<div class="iws-basic">
    <div class="iws-cache">
        <h2>
            <span class="iws-icon">
                <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 224 224"><g fill="none" stroke-miterlimit="10" font-family="none" font-size="none" font-weight="none" text-anchor="none" style="mix-blend-mode:normal"><path d="M0 224V0h224v224z"/><path fill="#ff9800" d="M112.175 29.342a7.467 7.467 0 0 0-2.552.379l-89.6 30.129a7.467 7.467 0 0 0 0 14.16l89.6 30.13a7.467 7.467 0 0 0 4.754 0l89.6-30.13a7.467 7.467 0 0 0 0-14.16l-89.6-30.13a7.467 7.467 0 0 0-2.202-.378zm89.76 59.952a7.467 7.467 0 0 0-2.712.423L112 119.058 24.777 89.717a7.469 7.469 0 0 0-4.754 14.16l89.6 30.13a7.467 7.467 0 0 0 4.754 0l89.6-30.13a7.467 7.467 0 0 0-2.042-14.583zm0 29.866a7.467 7.467 0 0 0-2.712.423L112 148.925l-87.223-29.342a7.469 7.469 0 1 0-4.754 14.16l89.6 30.13a7.467 7.467 0 0 0 4.754 0l89.6-30.13a7.467 7.467 0 0 0-2.042-14.583zm0 29.867a7.467 7.467 0 0 0-2.712.423L112 178.792 24.777 149.45a7.469 7.469 0 1 0-4.754 14.16l89.6 30.13a7.467 7.467 0 0 0 4.754 0l89.6-30.13a7.467 7.467 0 0 0-2.042-14.583z"/></g></svg>
            </span>
            Enable Cache Mechanism
        </h2>
        <table>
            <tr>
                <td>
                    <label for="cache-system"><?php _e('Cache System', 'ultimateoptimizer'); ?></label>
                </td>
                <td>
                    <input type="checkbox" class="chkbx-toggle" id="cache-system" class="chkbx-toggle" name="cache-system"
                           value='1' <?php checked($basic['ultimateoptimizer-active'], '1') ?>/>
                           <label for="cache-system"></label>
                    <span class="ultimateoptimizer_tool_tip">
                        <?php _e('This cache system will create static files of your whole website including menus, widgets and shortcodes. You dont need extra plugin.', 'ultimateoptimizer') ?>
                    </span>
                </td>
            </tr>
            <tr>
                <td>
                    <label for="cache-ttl"><?php _e('Purge cache after', 'ultimateoptimizer'); ?></label>
                </td>
                <td>
                    <input type="text" id="cache-ttl" size="5" name="cache-ttl"
                           value='<?php echo(!empty($basic['ultimateoptimizer-ttl']) ? (int)$basic['ultimateoptimizer-ttl'] : '1440'); ?>'/>
                    <span class="ultimateoptimizer_tool_tip" style="vertical-align: baseline">
                        <?php _e('Automatically purge internal cache after X minutes. By default this is set to 1440 minutes (1 day)', 'ultimateoptimizer') ?>
                    </span>
                </td>
            </tr>

            <tr>
                <td style="vertical-align: middle">
                    <span for="desktop-cache"> <?php _e('Desktop Cache', 'ultimateoptimizer') ?></span>
                </td>
                <td>
                    <select id="desktop-cache" name="desktop-cache">
                        <option value="1" <?php echo ($basic['ultimateoptimizer-desktop-cache'] == '1') ? 'selected="selected"' : '' ?>><?php _e('Activated', 'ultimateoptimizer') ?></option>
                        <option value="2" <?php echo ($basic['ultimateoptimizer-desktop-cache'] == '2') ? 'selected="selected"' : '' ?>><?php _e('No cache for desktop', 'ultimateoptimizer') ?></option>
                    </select>
                </td>
            </tr>

            <tr>
                <td style="vertical-align: middle">
                    <span for="mobile-cache"> <?php _e('Mobile Cache', 'ultimateoptimizer') ?></span>
                </td>
                <td>
                    <select id="mobile-cache" name="mobile-cache">
                        <option value="1" <?php echo ($basic['ultimateoptimizer-mobile-cache'] == '1') ? 'selected="selected"' : '' ?>><?php _e('Automatic (same as desktop)', 'ultimateoptimizer') ?></option>
                        <option value="3" <?php echo ($basic['ultimateoptimizer-mobile-cache'] == '3') ? 'selected="selected"' : '' ?>><?php _e('No cache for mobile', 'ultimateoptimizer') ?></option>
                    </select>
                </td>
            </tr>
        </table>
    </div>
    
    <div class="iws-minify">
        <h2>
            <span class="iws-icon">
                <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 224 224"><g fill="none" stroke-miterlimit="10" font-family="none" font-size="none" font-weight="none" style="mix-blend-mode:normal" text-anchor="none"><path d="M0 224V0h224v224z"/><path fill="#ff9800" d="M26.784 17.832a8.96 8.96 0 0 0-6.239 15.383L67.97 80.64H44.8a8.96 8.96 0 1 0 0 17.92h53.76V44.8a8.96 8.96 0 1 0-17.92 0v23.17L33.215 20.545a8.96 8.96 0 0 0-6.431-2.713zm170.161 0a8.96 8.96 0 0 0-6.16 2.713L143.36 67.97V44.8a8.96 8.96 0 1 0-17.92 0v53.76h53.76a8.96 8.96 0 1 0 0-17.92h-23.17l47.425-47.425a8.96 8.96 0 0 0-6.51-15.383zM44.8 125.44a8.96 8.96 0 1 0 0 17.92h23.17l-47.425 47.425a8.96 8.96 0 1 0 12.67 12.67L80.64 156.03v23.17a8.96 8.96 0 1 0 17.92 0v-53.76zm80.64 0v53.76a8.96 8.96 0 1 0 17.92 0v-23.17l47.425 47.425a8.96 8.96 0 1 0 12.67-12.67L156.03 143.36h23.17a8.96 8.96 0 1 0 0-17.92z"/></g></svg>
            </span>
            Enable Minification Mechanism
        </h2>
        <table>    
            <tr>
                <td style="vertical-align: middle">
                    <span for="mobile-cache"> <?php _e('Minify HTML', 'ultimateoptimizer') ?></span>
                </td>
                <td>
                    <input type="checkbox" class="chkbx-toggle" name="minification-html" id="minification-html" value="1" <?php checked($basic[ 'ultimateoptimizer-minify-html'], '1') ?>/>
                    <label for="minification-html"></label>
                    <span class="ultimateoptimizer_tool_tip" for="minification-html">
                    <?php _e('Remove Comments, Compress & Optimize HTML For Faster Page Load', 'ultimateoptimizer') ?>
                    </span>
                </td>
            </tr>
            <tr>
                <td style="vertical-align: middle">
                    <span for="mobile-cache"> <?php _e('Minify CSS', 'ultimateoptimizer') ?></span>
                </td>
                <td>
                    <input type="checkbox" class="chkbx-toggle" name="minification-css" id="minification-css" value="1" <?php checked($basic[ 'ultimateoptimizer-minify-css'], '1') ?>/>
                    <label for="minification-css"></label>
                    <span class="ultimateoptimizer_tool_tip" for="minification-css">
                    <?php _e('Compress Color Codes, Removes Blank Spaces & Optimizes All CSS Files For Faster Performance', 'ultimateoptimizer') ?>
                    </span>
                </td>
            </tr>
            <tr class="needspace">
                <td style="vertical-align: middle">
                    <span for="mobile-cache" class="ultimateoptimizer_tool_tip"></span>
                </td>
                <td>
                    <input type="checkbox" class="chkbx-toggle warning" name="include-inline-css" id="include-inline-css" value="1" <?php checked($basic[ 'ultimateoptimizer-include-inline-css'], '1') ?>/>
                    <label for="include-inline-css"></label>
                    <span class="ultimateoptimizer_tool_tip" for="include-inline-css">
                    <?php _e('Include inline CSS - WARNING: This option will dramatically increase your cache size.', 'ultimateoptimizer') ?>
                    </span>
                </td>
            </tr>
            <tr>
                <td style="vertical-align: middle">
                    <span for="mobile-cache"> <?php _e('Minify JS', 'ultimateoptimizer') ?></span>
                </td>
                <td>
                    <input type="checkbox" class="chkbx-toggle" name="minification-js" id="minification-js" value="1" <?php checked($basic[ 'ultimateoptimizer-minify-js'], '1') ?>/>
                    <label for="minification-js"></label>
                    <span class="ultimateoptimizer_tool_tip" for="minification-js">
                    <?php _e('Optimizes JS Functions & Rmoves Blank Spaces For Faster JS Delivery', 'ultimateoptimizer') ?>
                    </span>
                </td>
            </tr>
            <tr>
                <td style="vertical-align: middle">
                    <span for="mobile-cache" class="ultimateoptimizer_tool_tip"></span>
                </td>
                <td>
                    <input type="checkbox" class="chkbx-toggle warning" name="include-inline-js" id="include-inline-js" value="1" <?php checked($basic[ 'ultimateoptimizer-include-inline-js'], '1') ?>/>
                    <label for="include-inline-js"></label>
                    <span class="ultimateoptimizer_tool_tip" for="include-inline-js">
                    <?php _e('Include inline JS - WARNING: This option will dramatically increase your cache size.', 'ultimateoptimizer') ?>
                    </span>
                </td>
            </tr>
        </table>
    </div>
</div>