<?php
    defined('ABSPATH') or die;

    $cdn_integration = get_option('ultimateoptimizer_cdn_integration');

    $cdn_content_value = '';
    $cdn_exclude_content_value = '';
    if(!empty($cdn_integration['cdn-content'])){
        $cdn_content_value = implode(',',$cdn_integration['cdn-content']);
    }
    if(!empty($cdn_integration['cdn-exclude-content'])){
        $cdn_exclude_content_value = implode(',',$cdn_integration['cdn-exclude-content']);
    }
?>
<div class="iws-cdn">
    <h2>
        <span class="iws-icon">
            <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 224 224"><g fill="none" stroke-miterlimit="10" font-family="none" font-size="none" font-weight="none" style="mix-blend-mode:normal" text-anchor="none"><path d="M0 224V0h224v224z"/><path fill="#ff9800" d="M91 28v14H63c-11.512 0-21 9.488-21 21v28H28v42h42V91H56V63c0-3.965 3.035-7 7-7h28v14h42V28zm14 14h14v14h-14zm35 0v14h21c3.965 0 7 3.035 7 7v28h-14v42h42V91h-14V63c0-11.512-9.488-21-21-21zm-98 63h14v14H42zm126 0h14v14h-14zM42 140v21c0 11.512 9.488 21 21 21h28v14h42v-42H91v14H63c-3.965 0-7-3.035-7-7v-21zm126 0v21c0 3.965-3.035 7-7 7h-21v14h21c11.512 0 21-9.488 21-21v-21zm-63 28h14v14h-14z"/></g></svg>
        </span>
        Enable CDN Mechanism
    </h2>
    <table>
        <tr>
            <td>
                <label for="activate-cdn" class="ultimateoptimizer_tool_tip"><?php _e('Activate CDN', 'ultimateoptimizer')?></label>
            </td>
            <td>
                <input type="checkbox" class="chkbx-toggle" id="activate-cdn" name="activate-cdn"  value="1" <?php checked($cdn_integration['cdn-active'],'1')?>/>
                <label for="activate-cdn"></label>
                <span class="ultimateoptimizer_tool_tip"><?php _e('Enable to make CDN effective on your website.', 'ultimateoptimizer')?></span>
            </td>
        </tr>
        <tr>
            <td>
                <label for="cdn-url" class="ultimateoptimizer_tool_tip"><?php _e('CDN CNAME', 'ultimateoptimizer')?></label>
            </td>
            <td>
                <input type="text" id="cdn-url" name="cdn-url" size="50" placeholder="<?php _e('https://www.domain.com','ultimateoptimizer')?>" value="<?php echo (($cdn_integration['cdn-url'])?esc_html($cdn_integration['cdn-url']):''); ?>"/>
                <span style="vertical-align: baseline" class="ultimateoptimizer_tool_tip"><?php _e('Enter CDN CNAME.', 'ultimateoptimizer')?></span>
                <br>
                <span class="ultimateoptimizer_tool_tip"><b>Note:&nbsp;</b><?php _e('Use double slash ‘//’ at the start of CDN CNAME, if you have some pages on  HTTP and some are on HTTPS.', 'ultimateoptimizer') ?></span>
            </td>
        </tr>
        <tr>
            <td>
                <label for="cdn-content" class="ultimateoptimizer_tool_tip" ><?php _e('CDN Content', 'ultimateoptimizer')?></label>
            </td>
            <td>
                <input type="text" id="cdn-content" name="cdn-content" size="50" value="<?php echo (($cdn_content_value)?esc_html($cdn_content_value):''); ?>"/>
                <br>
                <span class="ultimateoptimizer_tool_tip"><b>Note:&nbsp;</b><?php _e('Enter the directories (comma separated) of which you want the CDN to serve the content.', 'ultimateoptimizer') ?></span>
            </td>
        </tr>
        <tr>
            <td>
                <label for="cdn-exclude-content" class="ultimateoptimizer_tool_tip" ><?php _e('Exclude Content', 'ultimateoptimizer')?></label>
            </td>
            <td>
                <input type="text" id="cdn-exclude-content" name="cdn-exclude-content" size="50" value="<?php echo (($cdn_exclude_content_value)?esc_html($cdn_exclude_content_value):''); ?>" />
                <br>
                <span class="ultimateoptimizer_tool_tip"><b>Note:&nbsp;</b><?php _e('Exclude file types or directories from CDN. Example, enter .css to exclude the CSS files.', 'ultimateoptimizer') ?></span>
            </td>
        </tr>
        <tr>
            <td>
                <label for="cdn-relative-path" class="ultimateoptimizer_tool_tip" ><?php _e('Relative path', 'ultimateoptimizer')?></label>
            </td>
            <td>
                <input type="checkbox" class="chkbx-toggle" id="cdn-relative-path" name="cdn-relative-path"  value="1" <?php checked($cdn_integration['cdn-relative-path'], '1')?>/>
                <label for="cdn-relative-path"></label>
                <span class="ultimateoptimizer_tool_tip"><?php _e('Keep this option enabled. Use this option to enable relative path for your CDN on your WordPress site.', 'ultimateoptimizer')?></span>
            </td>
        </tr>
    </table>
</div>