<?php
defined('ABSPATH') or die;
$post_revisions = 0; $drafted = 0; $trashed = 0; $comments = 0; $trackbacks = 0; $transients = 0;
if (is_multisite()) {
    $sites = get_sites();
    foreach ($sites as $site) {
        switch_to_blog($site->blog_id);
        $post_revisions += (int)Ultimateoptimizer_Configuration::getElementToClean('revisions');
        $drafted        += (int)Ultimateoptimizer_Configuration::getElementToClean('drafted');
	    $trashed        += (int)Ultimateoptimizer_Configuration::getElementToClean('trash');
	    $comments       += (int)Ultimateoptimizer_Configuration::getElementToClean('comments');
	    $trackbacks     += (int)Ultimateoptimizer_Configuration::getElementToClean('trackbacks');
	    $transients     += (int)Ultimateoptimizer_Configuration::getElementToClean('transient');
    }
    restore_current_blog();
} else {
    $post_revisions = (int)Ultimateoptimizer_Configuration::getElementToClean('revisions');
    $drafted        = (int)Ultimateoptimizer_Configuration::getElementToClean('drafted');
	$trashed        = (int)Ultimateoptimizer_Configuration::getElementToClean('trash');
	$comments       = (int)Ultimateoptimizer_Configuration::getElementToClean('comments');
	$trackbacks     = (int)Ultimateoptimizer_Configuration::getElementToClean('trackbacks');
	$transients     = (int)Ultimateoptimizer_Configuration::getElementToClean('transient');
}
?>
<div class="iws-database">
    <div class="ultimateoptimizer-top-notice">
        <h2>
            <span class="iws-icon">
                <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 224 224"><g fill="none" stroke-miterlimit="10" font-family="none" font-size="none" font-weight="none" style="mix-blend-mode:normal" text-anchor="none"><path d="M0 224V0h224v224z"/><path fill="#ff9800" d="M205.33 112a93.34 93.34 0 1 1-186.67 0 93.34 93.34 0 0 1 186.67 0z"/><path fill="#fff" d="M102.67 102.67h18.66V154h-18.66zM123.67 77a11.68 11.68 0 0 1-23.34 0 11.68 11.68 0 0 1 23.34 0z"/></g></svg>
            </span>
            <?php _e('Please, First Backup Your Database','ultimateoptimizer')?>
        </h2>
    </div>
    <table>
        <tr>
            <td>
                <label for="data0" class="ultimateoptimizer_tool_tip"><?php _e('Select all','ultimateoptimizer')?></label>
            </td>
            <td>
                <input type="checkbox" class="chkbx-toggle warning" id="data0" name="all_control" value="all_data"/>
                    <label for="data0"></label>
                <span class="ultimateoptimizer_tool_tip">
                    <?php _e('Select all options below. WARNING: If your site has "lots of database issues" & if you are on shared hosting, your site may go down due to server overload.','ultimateoptimizer')?> 
                </span>
            </td>
        </tr>
        <tr>
            <td>
                <label for="data1" class="ultimateoptimizer_tool_tip"><?php _e('Post revisions','ultimateoptimizer')?><?php echo '<span class="database-val">' . $post_revisions; ?></label>
            </td>
            <td>
                <input type="checkbox" class="chkbx-toggle database-all-optin" id="data1" name="clean[]" class="clean-data" value="revisions"/>
                    <label for="data1"></label>
                <span class="ultimateoptimizer_tool_tip"><?php _e('Use this option to delete all post revisions from the WordPress database.','ultimateoptimizer')?></span>
            </td>
        </tr>
        <tr>
            <td>
                <label for="data2" class="ultimateoptimizer_tool_tip" ><?php _e('Auto drafted content','ultimateoptimizer')?><?php echo '<span class="database-val">' . $drafted; ?></label>
            </td>
            <td>
                <input type="checkbox" class="chkbx-toggle database-all-optin" id="data2" name="clean[]" class="clean-data" value="drafted"/>
                <label for="data2"></label>
                <span class="ultimateoptimizer_tool_tip"><?php _e('Use this option to delete auto saved drafts from the WordPress database.','ultimateoptimizer')?></span>
            </td>
        </tr>
        <tr>
            <td>
                <label for="data3" class="ultimateoptimizer_tool_tip" ><?php _e('All trashed content','ultimateoptimizer')?><?php echo '<span class="database-val">' . $trashed; ?></label>
            </td>
            <td>
                <input type="checkbox" class="chkbx-toggle database-all-optin" id="data3" name="clean[]" class="clean-data" value="trash"/>
                <label for="data3"></label>
                <span class="ultimateoptimizer_tool_tip"><?php _e('Use this option to delete all trashed content from the WordPress database.','ultimateoptimizer')?></span>

            </td>
        </tr>
        <tr>
            <td>
                <label for="data4" class="ultimateoptimizer_tool_tip" ><?php _e('Comments from trash & spam','ultimateoptimizer')?><?php echo '<span class="database-val">' . $comments; ?></label>
            </td>
            <td>
                <input type="checkbox" class="chkbx-toggle database-all-optin" id="data4" name="clean[]" class="clean-data" value="comments"/>
                <label for="data4"></label>
                <span class="ultimateoptimizer_tool_tip"><?php _e('Use this option to delete trash and spam comments from the WordPress database.','ultimateoptimizer')?></span>
            </td>
        </tr>
        <tr>
            <td>
                <label for="data5" class="ultimateoptimizer_tool_tip" ><?php _e('Trackbacks and pingbacks','ultimateoptimizer')?><?php echo '<span class="database-val">' . $trackbacks; ?></label>
            </td>
            <td>
                <input type="checkbox" class="chkbx-toggle database-all-optin" id="data5" name="clean[]" class="clean-data" value="trackbacks"/>
                <label for="data5"></label>
                <span class="ultimateoptimizer_tool_tip"><?php _e('Use this option to delete Trackbacks and Pingbacks from the WordPress database.','ultimateoptimizer')?></span>
            </td>
        </tr>
        <tr>
            <td>
                <label for="data6" class="ultimateoptimizer_tool_tip" ><?php _e('Transient options','ultimateoptimizer')?><?php echo '<span class="database-val">' . $transients; ?></label>
            </td>
            <td>
                <input type="checkbox" class="chkbx-toggle database-all-optin" id="data6" name="clean[]" class="clean-data" value="transient"/>
                <label for="data6"></label>
                <span class="ultimateoptimizer_tool_tip"><?php _e('Delete expired and active transients from the WordPress database.','ultimateoptimizer')?></span>
            </td>
        </tr>
    </table>
</div>
