<?php
defined('ABSPATH') or die;

$must = get_option('ultimateoptimizer_must_settings');
?>

<div class="must">
    <div class="mustoptimize">
        <h2>
            <span class="iws-icon"><svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 224 224"><g fill="none" stroke-miterlimit="10" font-family="none" font-size="none" font-weight="none" style="mix-blend-mode:normal" text-anchor="none"><path d="M0 224V0h224v224z"/><path fill="#ff9800" d="M71.68 224c-.665 0-1.33-.14-1.9425-.455-2.03-.98-3.01-3.3075-2.31-5.4425l33.88-101.6225H67.2c-1.505 0-2.8875-.7525-3.7275-1.995-.84-1.2425-.98-2.8175-.4025-4.2l44.8-107.52C108.5525 1.085 110.1975 0 112 0h42.56c1.5225 0 2.94.77 3.7625 2.0475.8225 1.2775.945 2.87.3325 4.2525l-35.2625 78.82H156.8c1.645 0 3.15.91 3.9375 2.345.7875 1.4525.7175 3.2025-.1925 4.585l-85.12 129.92c-.8575 1.3125-2.275 2.03-3.745 2.03z"/></g></svg></span>
            Extra Boost
        </h2>
        <table>
            <tr>
                <td>
                    <span for="remove-query-strings"><?php _e('Remove Query Strings', 'ultimateoptimizer') ?></span>
                </td>
                <td>
                    <input type="checkbox" class="chkbx-toggle" id="remove-query-strings" name="remove-query-strings"
                           value='1' <?php checked($must['ultimateoptimizer-remove-query-strings'], '1') ?>/>
                           <label for="remove-query-strings"></label>
                    <span class="ultimateoptimizer_tool_tip"><?php _e('Remove 5 types of query string ( ?ver, &ver, ?v, &v, ?w ) from CSS, JS files.', 'ultimateoptimizer') ?></span>
                </td>
            </tr>
            <tr>
                <td>
                    <span for="remove-wp-embed-js"><?php _e('Remove wp_embed.js', 'ultimateoptimizer') ?></span>
                </td>
                <td>
                    <input type="checkbox" class="chkbx-toggle" id="remove-wp-embed-js" name="remove-wp-embed-js"
                           value='1' <?php checked($must['ultimateoptimizer-remove-wp-embed-js'], '1') ?>/>
                           <label for="remove-wp-embed-js"></label>
                    <span class="ultimateoptimizer_tool_tip"><?php _e('Remove wp_embed.js file from frontend.') ?></span>
                </td>
            </tr>
            <tr>
                <td>
                    <span for="remove-wp-emoji"><?php _e('Remove wp_emoji.js', 'ultimateoptimizer') ?></span>
                </td>
                <td>
                    <input type="checkbox" class="chkbx-toggle" id="remove-wp-emoji" name="remove-wp-emoji"
                           value='1' <?php checked($must['ultimateoptimizer-remove-wp-emoji'], '1') ?>/>
                           <label for="remove-wp-emoji"></label>
                    <span class="ultimateoptimizer_tool_tip"><?php _e('Remove wp-emoji-release.min.js file from frontend.') ?></span>
                </td>
            </tr>
        </table>
    </div>

    <div class="head-cleanup">
        <h2>
            <span class="iws-icon">
                <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 224 224"><g fill="none" stroke-miterlimit="10" font-family="none" font-size="none" font-weight="none" style="mix-blend-mode:normal" text-anchor="none"><path d="M0 224V0h224v224z"/><path fill="#ff9800" d="M89.88 17.92c-1.05-.0525-2.1.245-2.94.875-1.155.84-1.82 2.1875-1.82 3.605 0 57.295-68.1625 85.1725-68.8625 85.435-1.7325.7-2.8525 2.3975-2.8175 4.2525.0525 1.8725 1.2425 3.5175 3.01 4.13l103.04 35.84c.4725.175.98.2625 1.47.2625.6475 0 1.295-.14 1.89-.42 3.0275-1.4 74.27-35.035 74.27-98.14 0-1.9775-1.295-3.71-3.1675-4.2875l-103.04-31.36c-.35-.105-.7-.1575-1.0325-.1925zM194.3725 98.7c-6.4925 11.9175-15.015 22.1375-23.8175 30.6075l37.45-17.7275c1.645-.7875 2.6425-2.485 2.555-4.305-.105-1.82-1.295-3.3775-3.01-3.9725zm11.83 22.2425c-.7175-.0175-1.4.14-2.03.4375l-83.475 39.55L19.39 125.685c-2.345-.805-4.9.42-5.705 2.765-.805 2.345.42 4.9 2.765 5.705l103.04 35.84c1.1025.385 2.3275.315 3.3775-.175l85.12-40.32c1.925-.875 2.975-2.9575 2.5375-5.005-.4375-2.065-2.24-3.535-4.3225-3.5525zm0 17.92c-.7175-.0175-1.4.14-2.03.4375l-83.475 39.55L19.39 143.605c-2.345-.805-4.9.42-5.705 2.765-.805 2.345.42 4.9 2.765 5.705l103.04 35.84c1.1025.385 2.3275.315 3.3775-.175l85.12-40.32c1.925-.875 2.975-2.9575 2.5375-5.005-.4375-2.065-2.24-3.535-4.3225-3.5525zm0 17.92c-.7175-.0175-1.4.14-2.03.4375l-83.475 39.55L19.39 161.525c-2.345-.805-4.9.42-5.705 2.765-.805 2.345.42 4.9 2.765 5.705l103.04 35.84c1.1025.385 2.3275.315 3.3775-.175l85.12-40.32c1.925-.875 2.975-2.9575 2.5375-5.005-.4375-2.065-2.24-3.535-4.3225-3.5525z"/></g></svg>
            </span>
            Head Cleanup - Basically Remove All Junks
        </h2>
        <table>
            <tr>
                <td>
                    <span for="remove-wp-rsd"><?php _e('Remove RSD', 'ultimateoptimizer') ?></span>
                </td>
                <td>
                    <input type="checkbox" class="chkbx-toggle" id="remove-wp-rsd" name="remove-wp-rsd"
                           value='1' <?php checked($must['ultimateoptimizer-remove-wp-rsd'], '1') ?>/>
                           <label for="remove-wp-rsd"></label>
                    <span class="ultimateoptimizer_tool_tip"><?php _e('Remove Really Rimple Discovery Link.', 'ultimateoptimizer') ?></span>
                </td>
            </tr>
            <tr>
                <td>
                    <span for="remove-wp-gen"><?php _e('Remove Version', 'ultimateoptimizer') ?></span>
                </td>
                <td>
                    <input type="checkbox" class="chkbx-toggle" id="remove-wp-gen" name="remove-wp-gen"
                           value='1' <?php checked($must['ultimateoptimizer-remove-wp-gen'], '1') ?>/>
                           <label for="remove-wp-gen"></label>
                    <span class="ultimateoptimizer_tool_tip"><?php _e('Remove WordPress Generator Version.') ?></span>
                </td>
            </tr>
            <tr>
                <td>
                    <span for="remove-wp-feeds"><?php _e('Remove Feeds', 'ultimateoptimizer') ?></span>
                </td>
                <td>
                    <input type="checkbox" class="chkbx-toggle" id="remove-wp-feeds" name="remove-wp-feeds"
                           value='1' <?php checked($must['ultimateoptimizer-remove-wp-feeds'], '1') ?>/>
                           <label for="remove-wp-feeds"></label>
                    <span class="ultimateoptimizer_tool_tip"><?php _e('Remove WordPress Feed Links.') ?></span>
                </td>
            </tr>

            <tr>
                <td>
                    <span for="remove-mfest"><?php _e('Remove Manifest', 'ultimateoptimizer') ?></span>
                </td>
                <td>
                    <input type="checkbox" class="chkbx-toggle" id="remove-mfest" name="remove-mfest"
                           value='1' <?php checked($must['ultimateoptimizer-remove-mfest'], '1') ?>/>
                           <label for="remove-mfest"></label>
                    <span class="ultimateoptimizer_tool_tip"><?php _e('Remove WordPress Mainfest Links.') ?></span>
                </td>
            </tr>

            <tr>
                <td>
                    <span for="remove-wp-shortlink"><?php _e('Remove Shortlink', 'ultimateoptimizer') ?></span>
                </td>
                <td>
                    <input type="checkbox" class="chkbx-toggle" id="remove-wp-shortlink" name="remove-wp-shortlink"
                           value='1' <?php checked($must['ultimateoptimizer-remove-wp-shortlink'], '1') ?>/>
                           <label for="remove-wp-shortlink"></label>
                    <span class="ultimateoptimizer_tool_tip"><?php _e('Remove WordPress Short Links.') ?></span>
                </td>
            </tr>
        </table>
    </div>

    <div class="server-management">
        <h2>
            <span class="iws-icon">
                <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 224 224"><g fill="none" stroke-miterlimit="10" font-family="none" font-size="none" font-weight="none" style="mix-blend-mode:normal" text-anchor="none"><path d="M0 224V0h224v224z"/><path fill="#ff9800" d="M62.72 0c-3.96 0-6.86 1.54-8.96 3.22l-.14.14c-.63.5-1.19 1.05-1.68 1.54l-.28.28c-.02.04.02.1 0 .14l-7.98 8.96c1.75-.52 3.62-.84 5.6-.84h125.44c1.98 0 3.85.3 5.6.84l-8.26-9.38c-2.24-3-6.35-4.9-10.36-4.9zM49.28 22.4a8.66 8.66 0 0 0-8.96 8.96v183.68c0 5.2 3.76 8.96 8.96 8.96h125.44c5.2 0 8.96-3.76 8.96-8.96V31.36c0-5.2-3.76-8.96-8.96-8.96zm22.4 22.4h80.64c2.7 0 4.48 1.78 4.48 4.48v22.4c0 2.7-1.79 4.48-4.48 4.48H71.68c-2.7 0-4.48-1.78-4.48-4.48v-22.4c0-2.7 1.78-4.48 4.48-4.48zm0 40.32h80.64c2.7 0 4.48 1.78 4.48 4.48V112c0 2.7-1.79 4.48-4.48 4.48H71.68c-2.7 0-4.48-1.78-4.48-4.48V89.6c0-2.7 1.78-4.48 4.48-4.48zM112 143.36a8.98 8.98 0 0 1 8.96 8.96 8.98 8.98 0 0 1-8.96 8.96 8.98 8.98 0 0 1-8.96-8.96 8.98 8.98 0 0 1 8.96-8.96zm0 31.36a8.98 8.98 0 0 1 8.96 8.96 8.98 8.98 0 0 1-8.96 8.96 8.98 8.98 0 0 1-8.96-8.96 8.98 8.98 0 0 1 8.96-8.96z"/></g></svg>
            </span>
            Server Optimization
        </h2>
        <table>
            <tr>
                <td>
                    <span for="enable-gzip"><?php _e('Enable GZip', 'ultimateoptimizer') ?></span>
                </td>
                <td>
                    <input type="checkbox" class="chkbx-toggle" id="enable-gzip" name="enable-gzip"
                           value='1' <?php checked($must['ultimateoptimizer-enable-gzip'], '1') ?>/>
                           <label for="enable-gzip"></label>
                    <span class="ultimateoptimizer_tool_tip"><?php _e('Enables GZIP compression on your server.', 'ultimateoptimizer') ?></span>
                </td>
            </tr>
            <tr>
                <td>
                    <span for="enable-browser-cache"><?php _e('Browser Cache', 'ultimateoptimizer') ?></span>
                </td>
                <td>
                    <input type="checkbox" class="chkbx-toggle" id="enable-browser-cache" name="enable-browser-cache"
                           value='1' <?php checked($must['ultimateoptimizer-enable-browser-cache'], '1') ?>/>
                           <label for="enable-browser-cache"></label>
                    <span class="ultimateoptimizer_tool_tip"><?php _e('Enable Browser Cache.') ?></span>
                </td>
            </tr>
            <tr>
                <td>
                    <span for="unset-etag"><?php _e('Unset ETags', 'ultimateoptimizer') ?></span>
                </td>
                <td>
                    <input type="checkbox" class="chkbx-toggle" id="unset-etag" name="unset-etag"
                           value='1' <?php checked($must['ultimateoptimizer-unset-etag'], '1') ?>/>
                           <label for="unset-etag"></label>
                    <span class="ultimateoptimizer_tool_tip"><?php _e('Unset Etags') ?></span>
                </td>
            </tr>
        </table>
    </div>
</div>