<?php
defined('ABSPATH') or die;

$varnish = get_option('ultimateoptimizer_varnish_cache');
$check_varnish = Ultimateoptimizer_Admin::check_varnish();
?>
<div class="iws-varnish">
    <h2>
        <span class="iws-icon">
            <img src="data:image/png;base64,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">
        </span>
        Enable Varnish
    </h2>
    <?php if( !$check_varnish): ?>
        <p class="varnish-not-enabled">
            <span class="iws-icon" style="left: 20px;">
                <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 224 224"><g fill="none" stroke-miterlimit="10" font-family="none" font-size="none" font-weight="none" style="mix-blend-mode:normal" text-anchor="none"><path d="M0 224V0h224v224z"/><g fill="#fff"><path d="M112 196c-46.2 0-84-37.8-84-84s37.8-84 84-84 84 37.8 84 84-37.8 84-84 84zm0-154c-38.733 0-70 31.267-70 70 0 38.733 31.267 70 70 70 38.733 0 70-31.267 70-70 0-38.733-31.267-70-70-70z"/><path d="M28.467 186.667C10.267 166.133 0 139.533 0 112s10.267-54.133 28.467-74.667L42 50.4C27.067 67.2 18.667 89.133 18.667 112c0 22.867 8.4 44.8 23.333 61.6zM195.533 186.667C213.733 166.133 224 139.533 224 112s-10.267-54.133-28.467-74.667L182 50.4c14.933 17.267 23.333 38.733 23.333 61.6 0 22.867-8.4 44.8-23.333 61.6zM121.333 144.667V154c0 2.8-1.866 4.667-4.666 4.667h-9.334c-2.8 0-4.666-1.867-4.666-4.667v-9.333c0-2.8 1.866-4.667 4.666-4.667h9.334c2.8 0 4.666 1.867 4.666 4.667zM121.333 65.333V126c0 2.8-1.866 4.667-4.666 4.667h-9.334c-2.8 0-4.666-1.867-4.666-4.667V65.333c0-2.8 1.866-4.666 4.666-4.666h9.334c2.8 0 4.666 1.866 4.666 4.666z"/></g></g></svg>
            </span>
        Varnish is not enabled on your server, none of the settings below will work unless varnish is installed and configured properly.</p>
    <?php endif; ?>
    <table>
        <tr>
            <td>
                <label for="auto-purge-varnish" class="ultimateoptimizer_tool_tip"><?php _e('Auto Purge Varnish', 'ultimateoptimizer'); ?></label>
            </td>
            <td>
                <input type="checkbox" class="chkbx-toggle" id="auto-purge-varnish" name="auto-purge-varnish" value="1"  <?php checked($varnish['auto-purge-varnish'], '1')?>/>
                <label for="auto-purge-varnish"></label>
                <span class="ultimateoptimizer_tool_tip" ><?php _e('Keep this option enabled to automatically purge Varnish cache on actions like publishing new blog posts, pages and comments.','ultimateoptimizer')?></span> u
            </td>
        </tr>
        <tr>
            <td>
                <label for="varnish-server-ip" class="ultimateoptimizer_tool_tip"><?php _e('Varnish server', 'ultimateoptimizer'); ?></label>
            </td>
            <td>
                <input type="text" id="varnish-server-ip" size="20" name="varnish-server-ip"
                       value='<?php echo(!empty($varnish['ultimateoptimizer-varnish-server-ip']) ? esc_html($varnish['ultimateoptimizer-varnish-server-ip']) : '127.0.0.1'); ?>'/>
            </td>
        </tr>
        <tr>
            <td style="vertical-align: middle">
                <label class="ultimateoptimizer_tool_tip"><?php _e('Purge Varnish Cache', 'ultimateoptimizer'); ?></label>
            </td>
            <td>
                <input type="button" id="purge-varnish-button" class="button" value="<?php _e('Purge','ultimateoptimizer')?>"  />
            </td>
        </tr>
    </table>
</div>