<?php
defined('ABSPATH') or die;

$tabs = array(
    'basic' => __('BASIC', 'ultimateoptimizer'),
    'must' => __('MUST', 'ultimateoptimizer'),
    'advanced' => __('ADVANCED', 'ultimateoptimizer'),
    'database' => __('DATABASE', 'ultimateoptimizer'),
    'cdn' => __('CDN', 'ultimateoptimizer'),
    'varnish' => __('VARNISH', 'ultimateoptimizer'),
);

wp_enqueue_script('jquery-ui', plugins_url('assets/js/jquery-ui-sortable.min.js', dirname(__FILE__)), null, ULTIMATEOPTIMIZER_VERSION, true);

?>
<?php if (isset($_REQUEST['database-cleanup']) && $_REQUEST['database-cleanup'] == 'success'): ?>
    <div id="message-save-settings" class="notice notice-success" style="margin: 10px 0px 10px 0;padding: 10px;"><strong><?php _e('Database cleanup successful', 'ultimateoptimizer'); ?></strong></div>
<?php endif; ?>
<!--save settings successfull message-->
<?php if (isset($_REQUEST['save-settings']) && $_REQUEST['save-settings'] == 'success'): ?>
     <div id="message-save-settings" class="notice notice-success" style="margin: 10px 0px 10px 0;padding: 10px;"><strong><?php _e('Configuration settings saved', 'ultimateoptimizer'); ?></strong></div>
<?php endif; ?>
<div class="wrap ultimateoptimizer-main">
    <div class="ultimateoptimizer-header">
        <h2>
            <span>
                <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 224 224"><g fill="none" stroke-miterlimit="10" font-family="none" font-size="none" font-weight="none" style="mix-blend-mode:normal" text-anchor="none"><path d="M0 224V0h224v224z"/><g fill="#3f51b5"><path d="M80.57 197.974c-16.329-9.207-25.07-32.34-16.04-47.404 8.242-14.294 32.303-21.462 53.845-8.279 11.596 7.131 25.34 12.983 42.088 12.983 15.47 0 30.072-9.207 38.244-23.025 3.005-5.022 5.152-11.298 6.444-15.484-.434 14.653-4.732 29.712-12.889 43.12-20.622 35.588-77.327 57.764-111.692 38.089z"/><path d="M54.26 41.93c16.225-8.47 41.411-5.493 49.097 11.013 6.837 14.817 6.893 35.574-20.916 50.377-11.956 6.351-25.615 13.977-33.306 28.383-7.256 13.547-8.12 30.053 0 44.454 2.987 5.078 7.257 10.584 10.239 13.548-12.376-8.055-23.049-19.484-30.74-33.871-19.3-34.79-9.818-95.26 25.625-113.904z"/><path d="M200.667 93.16c0 17.92-15.685 37.507-33.918 37.507-16.958 0-33.917-9.572-33.917-41.254 0-13.332-1.274-28.751-9.753-42.098-8.05-12.908-22.965-21.275-39.513-20.855-4.56.005-9.543.443-13.566 1.54 2.8-1.288 4.956-2.473 9.39-4.027 9.715-3.398 20.327-5.017 31.392-5.306 41.557 0 89.455 35.746 89.885 74.494z"/></g></g></svg>
            </span>
            Ultimate Optimizer
        </h2>
    </div>

    <h1 style="clear: both"></h1>
    <div class="inner-wrap">

        <ul id="ultimateoptimizer-tabs" class="nav-tab-wrapper">
            <?php
            foreach ($tabs as $key => $name) {
                echo '<li><a id="tab-' . $key . '" class="nav-tab" href="#tab-' . $key . '" data-tab-id="' . $key . '"> ' . $name . ' </a></li>';
            }
            ?>
        </ul>

        <div id="ultimateoptimizer-tabs-content" class="tab-content">
            <?php
            foreach ($tabs as $key => $name) {
                echo '<div id="tab-content-' . $key . '" class="tab-pane">';
                echo '<form class="ultimateoptimizer-form" method="post" action="">';
                echo '<div class="tab-child">';
                echo '<input type="hidden" name="ultimateoptimizer_'.$key.'_action" value="ultimateoptimizer_'.$key.'_settings">';
                wp_nonce_field('ultimateoptimizer_settings_' . $key, 'ultimateoptimizer_settings_' . $key . '_nonce');
                Ultimateoptimizer_Admin::render($key);
                echo '</div>';
                if ($key == 'database'){
                    echo '<p class="submit">
                     <input type="submit" class="button button-primary" value="'. __('Optimize', 'ultimateoptimizer') .'"/>
                         </p>';
                }else{
                    if ($key != 'faq') {
    	                echo '<p class="submit">
                            <input type="submit" class="button button-primary" value="'. __('Save Changes', 'ultimateoptimizer') .'"/>
                            </p>';
                    }
                }
                echo '</form>';
                echo '</div>';
            }
            ?>
        </div>
    </div>
</div>
